/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.awt.RenderingHints;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.measure.converter.ConversionException;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.DefaultConcatenatedOperation;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.CanonicalSet;
import org.geotools.util.Utilities;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCoordinateOperationFactory
extends ReferencingFactory
implements CoordinateOperationFactory {
    protected static final ReferenceIdentifier IDENTITY = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)207));
    protected static final ReferenceIdentifier AXIS_CHANGES = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)204));
    protected static final ReferenceIdentifier DATUM_SHIFT = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)205));
    protected static final ReferenceIdentifier ELLIPSOID_SHIFT = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)206));
    protected static final ReferenceIdentifier GEOCENTRIC_CONVERSION = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)53));
    protected static final ReferenceIdentifier INVERSE_OPERATION = new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)208));
    private final ReferencingFactoryContainer factories;
    private final MathTransformFactory mtFactory;
    private final CanonicalSet<CoordinateOperation> pool = CanonicalSet.newInstance(CoordinateOperation.class);
    private boolean hintsInitialized;

    public AbstractCoordinateOperationFactory(Hints userHints) {
        this(userHints, 50);
    }

    public AbstractCoordinateOperationFactory(Hints userHints, int priority) {
        super(priority);
        this.factories = ReferencingFactoryContainer.instance(userHints);
        this.mtFactory = this.factories.getMathTransformFactory();
    }

    AbstractCoordinateOperationFactory(CoordinateOperationFactory factory, Hints hints, int priority) {
        super(priority);
        this.factories = factory instanceof AbstractCoordinateOperationFactory ? ((AbstractCoordinateOperationFactory)factory).getFactoryContainer() : ReferencingFactoryContainer.instance(hints);
        this.mtFactory = this.factories.getMathTransformFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        Map map = this.hints;
        synchronized (map) {
            if (!this.hintsInitialized) {
                this.initializeHints();
                this.hintsInitialized = true;
            }
        }
        return super.getImplementationHints();
    }

    void initializeHints() {
        assert (Thread.holdsLock(this.hints));
        ReferencingFactoryContainer factories = this.getFactoryContainer();
        this.hints.putAll(factories.getImplementationHints());
    }

    public final MathTransformFactory getMathTransformFactory() {
        return this.mtFactory;
    }

    final ReferencingFactoryContainer getFactoryContainer() {
        return this.factories;
    }

    protected Matrix swapAndScaleAxis(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws OperationNotFoundException {
        try {
            return AbstractCS.swapAndScaleAxis(sourceCS, targetCS);
        }
        catch (IllegalArgumentException exception) {
            throw new OperationNotFoundException(AbstractCoordinateOperationFactory.getErrorMessage((IdentifiedObject)sourceCS, (IdentifiedObject)targetCS), (Throwable)exception);
        }
        catch (ConversionException exception) {
            throw new OperationNotFoundException(AbstractCoordinateOperationFactory.getErrorMessage((IdentifiedObject)sourceCS, (IdentifiedObject)targetCS), (Throwable)exception);
        }
    }

    private static Map<String, Object> getProperties(ReferenceIdentifier name) {
        HashMap<String, Object> properties;
        if (name == DATUM_SHIFT || name == ELLIPSOID_SHIFT) {
            properties = new HashMap<String, ReferenceIdentifier>(4);
            properties.put("name", name);
            properties.put("coordinateOperationAccuracy", new PositionalAccuracy[]{name == DATUM_SHIFT ? PositionalAccuracyImpl.DATUM_SHIFT_APPLIED : PositionalAccuracyImpl.DATUM_SHIFT_OMITTED});
        } else {
            properties = Collections.singletonMap("name", name);
        }
        return properties;
    }

    protected CoordinateOperation createFromAffineTransform(ReferenceIdentifier name, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Matrix matrix) throws FactoryException {
        MathTransform transform = this.mtFactory.createAffineTransform(matrix);
        Map<String, Object> properties = AbstractCoordinateOperationFactory.getProperties(name);
        Class type = properties.containsKey("coordinateOperationAccuracy") ? Transformation.class : Conversion.class;
        return this.createFromMathTransform(properties, sourceCRS, targetCRS, transform, ProjectiveTransform.ProviderAffine.getProvider(transform.getSourceDimensions(), transform.getTargetDimensions()), type);
    }

    protected CoordinateOperation createFromParameters(ReferenceIdentifier name, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, ParameterValueGroup parameters) throws FactoryException {
        Map<String, Object> properties = AbstractCoordinateOperationFactory.getProperties(name);
        MathTransform transform = this.mtFactory.createParameterizedTransform(parameters);
        OperationMethod method = this.mtFactory.getLastMethodUsed();
        return this.createFromMathTransform(properties, sourceCRS, targetCRS, transform, method, Operation.class);
    }

    protected CoordinateOperation createFromMathTransform(ReferenceIdentifier name, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) throws FactoryException {
        return this.createFromMathTransform(Collections.singletonMap("name", name), sourceCRS, targetCRS, transform, null, CoordinateOperation.class);
    }

    protected CoordinateOperation createFromMathTransform(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method, Class<? extends CoordinateOperation> type) throws FactoryException {
        CoordinateOperation operation;
        if (transform instanceof CoordinateOperation && Utilities.equals((Object)(operation = (CoordinateOperation)transform).getSourceCRS(), (Object)sourceCRS) && Utilities.equals((Object)operation.getTargetCRS(), (Object)targetCRS) && Utilities.equals((Object)operation.getMathTransform(), (Object)transform)) {
            if (operation instanceof Operation) {
                if (Utilities.equals((Object)((Operation)operation).getMethod(), (Object)method)) {
                    return operation;
                }
            } else {
                return operation;
            }
        }
        operation = DefaultOperation.create(properties, sourceCRS, targetCRS, transform, method, type);
        operation = (CoordinateOperation)this.pool.unique((Object)operation);
        return operation;
    }

    public Conversion createDefiningConversion(Map<String, ?> properties, OperationMethod method, ParameterValueGroup parameters) throws FactoryException {
        DefiningConversion conversion = new DefiningConversion(properties, method, parameters);
        conversion = (Conversion)this.pool.unique((Object)conversion);
        return conversion;
    }

    public CoordinateOperation createConcatenatedOperation(Map<String, ?> properties, CoordinateOperation[] operations) throws FactoryException {
        DefaultConcatenatedOperation operation = new DefaultConcatenatedOperation(properties, operations, this.mtFactory);
        operation = (CoordinateOperation)this.pool.unique((Object)operation);
        return operation;
    }

    protected CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2) throws FactoryException {
        if (step1 == null) {
            return step2;
        }
        if (step2 == null) {
            return step1;
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step1)) {
            return step2;
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step2)) {
            return step1;
        }
        MathTransform mt1 = step1.getMathTransform();
        MathTransform mt2 = step2.getMathTransform();
        CoordinateReferenceSystem sourceCRS = step1.getSourceCRS();
        CoordinateReferenceSystem targetCRS = step2.getTargetCRS();
        CoordinateOperation step = null;
        if (step1.getName() == AXIS_CHANGES && mt1.getSourceDimensions() == mt1.getTargetDimensions()) {
            step = step2;
        }
        if (step2.getName() == AXIS_CHANGES && mt2.getSourceDimensions() == mt2.getTargetDimensions()) {
            step = step1;
        }
        if (step instanceof Operation) {
            return this.createFromMathTransform(AbstractIdentifiedObject.getProperties((IdentifiedObject)step), sourceCRS, targetCRS, this.mtFactory.createConcatenatedTransform(mt1, mt2), ((Operation)step).getMethod(), CoordinateOperation.class);
        }
        return this.createConcatenatedOperation(AbstractCoordinateOperationFactory.getTemporaryName(sourceCRS, targetCRS), new CoordinateOperation[]{step1, step2});
    }

    protected CoordinateOperation concatenate(CoordinateOperation step1, CoordinateOperation step2, CoordinateOperation step3) throws FactoryException {
        if (step1 == null) {
            return this.concatenate(step2, step3);
        }
        if (step2 == null) {
            return this.concatenate(step1, step3);
        }
        if (step3 == null) {
            return this.concatenate(step1, step2);
        }
        assert (CRS.equalsIgnoreMetadata(step1.getTargetCRS(), step2.getSourceCRS())) : step1;
        assert (CRS.equalsIgnoreMetadata(step2.getTargetCRS(), step3.getSourceCRS())) : step3;
        if (AbstractCoordinateOperationFactory.isIdentity(step1)) {
            return this.concatenate(step2, step3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step2)) {
            return this.concatenate(step1, step3);
        }
        if (AbstractCoordinateOperationFactory.isIdentity(step3)) {
            return this.concatenate(step1, step2);
        }
        if (step1.getName() == AXIS_CHANGES) {
            return this.concatenate(this.concatenate(step1, step2), step3);
        }
        if (step3.getName() == AXIS_CHANGES) {
            return this.concatenate(step1, this.concatenate(step2, step3));
        }
        CoordinateReferenceSystem sourceCRS = step1.getSourceCRS();
        CoordinateReferenceSystem targetCRS = step3.getTargetCRS();
        return this.createConcatenatedOperation(AbstractCoordinateOperationFactory.getTemporaryName(sourceCRS, targetCRS), new CoordinateOperation[]{step1, step2, step3});
    }

    private static boolean isIdentity(CoordinateOperation operation) {
        return operation instanceof Conversion && operation.getMathTransform().isIdentity();
    }

    protected CoordinateOperation inverse(CoordinateOperation operation) throws NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        CoordinateReferenceSystem targetCRS = operation.getTargetCRS();
        Map<String, Object> properties = AbstractIdentifiedObject.getProperties((IdentifiedObject)operation, null);
        properties.putAll(AbstractCoordinateOperationFactory.getTemporaryName(targetCRS, sourceCRS));
        if (operation instanceof ConcatenatedOperation) {
            LinkedList<CoordinateOperation> inverted = new LinkedList<CoordinateOperation>();
            for (SingleOperation op : ((ConcatenatedOperation)operation).getOperations()) {
                inverted.addFirst(this.inverse((CoordinateOperation)op));
            }
            return this.createConcatenatedOperation(properties, inverted.toArray(new CoordinateOperation[inverted.size()]));
        }
        MathTransform transform = operation.getMathTransform().inverse();
        Class<? extends CoordinateOperation> type = AbstractCoordinateOperation.getType(operation);
        OperationMethod method = operation instanceof Operation ? ((Operation)operation).getMethod() : null;
        return this.createFromMathTransform(properties, targetCRS, sourceCRS, transform, method, type);
    }

    static int getDimension(CoordinateReferenceSystem crs) {
        return crs != null ? crs.getCoordinateSystem().getDimension() : 0;
    }

    private static String getClassName(IdentifiedObject object) {
        if (object != null) {
            Class<?> type = object.getClass();
            Class<?>[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> candidate = interfaces[i];
                if (!candidate.getName().startsWith("org.opengis.referencing.")) continue;
                type = candidate;
                break;
            }
            String name = Classes.getShortName(type);
            ReferenceIdentifier id = object.getName();
            if (id != null) {
                name = name + '[' + id.getCode() + ']';
            }
            return name;
        }
        return null;
    }

    static Map<String, Object> getTemporaryName(IdentifiedObject source) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", new TemporaryIdentifier(source.getName()));
        properties.put("remarks", Vocabulary.formatInternational((int)209, (Object)AbstractCoordinateOperationFactory.getClassName(source)));
        return properties;
    }

    static Map<String, ?> getTemporaryName(CoordinateReferenceSystem source, CoordinateReferenceSystem target) {
        String name = AbstractCoordinateOperationFactory.getClassName((IdentifiedObject)source) + " \u21e8 " + AbstractCoordinateOperationFactory.getClassName((IdentifiedObject)target);
        return Collections.singletonMap("name", name);
    }

    protected static String getErrorMessage(IdentifiedObject source, IdentifiedObject target) {
        return Errors.format((int)102, (Object)AbstractCoordinateOperationFactory.getClassName(source), (Object)AbstractCoordinateOperationFactory.getClassName(target));
    }

    protected static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((int)105, (Object)name));
        }
    }

    private static final class TemporaryIdentifier
    extends NamedIdentifier {
        private static final long serialVersionUID = -2784354058026177076L;
        private final ReferenceIdentifier parent;
        private final int count;

        public TemporaryIdentifier(ReferenceIdentifier parent) {
            this(parent, (parent instanceof TemporaryIdentifier ? ((TemporaryIdentifier)parent).count : 0) + 1);
        }

        private TemporaryIdentifier(ReferenceIdentifier parent, int count) {
            super(Citations.GEOTOOLS, TemporaryIdentifier.unwrap(parent).getCode() + " (step " + count + ')');
            this.parent = parent;
            this.count = count;
        }

        public static ReferenceIdentifier unwrap(ReferenceIdentifier identifier) {
            while (identifier instanceof TemporaryIdentifier) {
                identifier = ((TemporaryIdentifier)identifier).parent;
            }
            return identifier;
        }
    }
}

