/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.wkt.Formatter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectedCRS
extends AbstractDerivedCRS
implements ProjectedCRS {
    private static final long serialVersionUID = -4502680112031773028L;
    private static final String SEMI_MAJOR = "semi_major";
    private static final String SEMI_MINOR = "semi_minor";

    public DefaultProjectedCRS(ProjectedCRS crs) {
        super((GeneralDerivedCRS)crs);
    }

    public DefaultProjectedCRS(String name, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws MismatchedDimensionException {
        this(Collections.singletonMap("name", name), base, baseToDerived, derivedCS);
    }

    public DefaultProjectedCRS(Map<String, ?> properties, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws MismatchedDimensionException {
        super(properties, (CoordinateReferenceSystem)base, baseToDerived, (CoordinateSystem)derivedCS);
    }

    public DefaultProjectedCRS(Map<String, ?> properties, OperationMethod method, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws MismatchedDimensionException {
        super(properties, method, (CoordinateReferenceSystem)base, baseToDerived, (CoordinateSystem)derivedCS);
    }

    public DefaultProjectedCRS(Map<String, ?> properties, Conversion conversionFromBase, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws MismatchedDimensionException {
        super(properties, conversionFromBase, (CoordinateReferenceSystem)base, baseToDerived, (CoordinateSystem)derivedCS);
    }

    public CartesianCS getCoordinateSystem() {
        return (CartesianCS)super.getCoordinateSystem();
    }

    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    public GeographicCRS getBaseCRS() {
        return (GeographicCRS)super.getBaseCRS();
    }

    public Projection getConversionFromBase() {
        return (Projection)super.getConversionFromBase();
    }

    Class<? extends Projection> getConversionType() {
        return Projection.class;
    }

    @Override
    public int hashCode() {
        return 0x59214E9C ^ super.hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        Ellipsoid ellipsoid = ((GeodeticDatum)this.datum).getEllipsoid();
        Unit<?> unit = this.getUnit();
        Unit<Length> linearUnit = formatter.getLinearUnit();
        Unit<Angle> angularUnit = formatter.getAngularUnit();
        Unit axisUnit = ellipsoid.getAxisUnit();
        formatter.setLinearUnit(unit);
        formatter.setAngularUnit(DefaultGeographicCRS.getAngularUnit(this.baseCRS.getCoordinateSystem()));
        formatter.append((IdentifiedObject)this.baseCRS);
        formatter.append((IdentifiedObject)this.conversionFromBase.getMethod());
        for (GeneralParameterValue param : this.conversionFromBase.getParameterValues().values()) {
            block8: {
                String name;
                block7: {
                    GeneralParameterDescriptor desc = param.getDescriptor();
                    name = SEMI_MAJOR;
                    if (DefaultProjectedCRS.nameMatches((IdentifiedObject)desc, SEMI_MAJOR)) break block7;
                    name = SEMI_MINOR;
                    if (!DefaultProjectedCRS.nameMatches((IdentifiedObject)desc, SEMI_MINOR)) break block8;
                }
                if (param instanceof ParameterValue) {
                    double expected;
                    double value = ((ParameterValue)param).doubleValue(axisUnit);
                    double d = expected = name == SEMI_MINOR ? ellipsoid.getSemiMinorAxis() : ellipsoid.getSemiMajorAxis();
                    if (value == expected) continue;
                }
            }
            formatter.append(param);
        }
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append((IdentifiedObject)this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(ProjectedCRS.class);
        }
        formatter.setAngularUnit(angularUnit);
        formatter.setLinearUnit(linearUnit);
        return "PROJCS";
    }
}

