/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.URN_AuthorityFactory;
import org.geotools.referencing.factory.URN_Type;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Version;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.NoSuchAuthorityCodeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class URN_Parser {
    private static final String[] URN_BASES = new String[]{"urn:ogc:def:", "urn:x-ogc:def:"};
    private static final char SEPARATOR = ':';
    public final String urn;
    public final URN_Type type;
    public final String authority;
    public final Version version;
    public final String code;

    public URN_Parser(String urn) throws NoSuchAuthorityCodeException {
        this.urn = urn;
        String code = urn.trim();
        String type = urn;
        for (int i = 0; i < URN_BASES.length; ++i) {
            int nameEnd;
            URN_Type candidate;
            int typeEnd;
            String urnBase = URN_BASES[i];
            int typeStart = urnBase.length();
            if (!code.regionMatches(true, 0, urnBase, 0, typeStart) || (typeEnd = code.indexOf(58, typeStart)) < 0 || (candidate = URN_Type.get(type = code.substring(typeStart, typeEnd).trim())) == null || (nameEnd = code.indexOf(58, typeEnd + 1)) < 0) continue;
            int lastEnd = code.lastIndexOf(58);
            this.version = lastEnd <= nameEnd ? null : new Version(code.substring(nameEnd + 1, lastEnd));
            this.authority = code.substring(typeEnd + 1, nameEnd).trim();
            this.code = code.substring(lastEnd + 1).trim();
            this.type = candidate;
            return;
        }
        throw new NoSuchAuthorityCodeException(Errors.format((int)67, (Object)type), "urn:ogc:def", type);
    }

    public String getAuthorityCode() {
        return this.authority + ':' + this.code;
    }

    final void logWarningIfTypeMismatch(Class<? extends AuthorityFactory> expected) {
        if (!expected.isAssignableFrom(this.type.type)) {
            String urn = "...:" + this.type + ':' + this.authority + ':' + this.code;
            LogRecord record = Loggings.format((Level)Level.WARNING, (int)30, (Object)urn);
            record.setSourceClassName(URN_AuthorityFactory.class.getName());
            record.setSourceMethodName("get" + Classes.getShortName(expected));
            Logger logger = AbstractAuthorityFactory.LOGGER;
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
    }

    public String toString() {
        return this.urn;
    }
}

