/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collections;
import java.util.StringTokenizer;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.VerticalTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.referencing.operation.Transformation;

public final class EarthGravitationalModel
extends VerticalTransform {
    private static final double SQRT_03 = 1.7320508075688772;
    private static final double SQRT_05 = 2.23606797749979;
    private static final double SQRT_13 = 3.605551275463989;
    private static final double SQRT_17 = 4.123105625617661;
    private static final double SQRT_21 = 4.58257569495584;
    static final int DEFAULT_ORDER = 180;
    private final boolean wgs84;
    private final int nmax;
    private final double semiMajor;
    private final double esq;
    private final double c2;
    private final double rkm;
    private final double grava;
    private final double star;
    private final double[] cnmGeopCoef;
    private final double[] snmGeopCoef;
    private final double[] aClenshaw;
    private final double[] bClenshaw;
    private final double[] as;
    private final double[] cr;
    private final double[] sr;
    private final double[] s11;
    private final double[] s12;

    EarthGravitationalModel() {
        this(180, true);
    }

    EarthGravitationalModel(int nmax, boolean wgs84) {
        this.nmax = nmax;
        this.wgs84 = wgs84;
        if (wgs84) {
            this.semiMajor = 6378137.0;
            this.esq = 0.00669437999013;
            this.c2 = 0.00108262998905;
            this.rkm = 3.986004418E14;
            this.grava = 9.7803267714;
            this.star = 0.001931851386;
        } else {
            this.semiMajor = 6378135.0;
            this.esq = 0.006694317778;
            this.c2 = 0.00108263;
            this.rkm = 3.986005E14;
            this.grava = 9.7803327;
            this.star = 0.005278994;
        }
        int cleanshawLength = EarthGravitationalModel.locatingArray(nmax + 3);
        int geopCoefLength = EarthGravitationalModel.locatingArray(nmax + 1);
        this.aClenshaw = new double[cleanshawLength];
        this.bClenshaw = new double[cleanshawLength];
        this.cnmGeopCoef = new double[geopCoefLength];
        this.snmGeopCoef = new double[geopCoefLength];
        this.as = new double[nmax + 1];
        this.cr = new double[nmax + 1];
        this.sr = new double[nmax + 1];
        this.s11 = new double[nmax + 3];
        this.s12 = new double[nmax + 3];
    }

    private static int locatingArray(int n) {
        return (n + 1) * n >> 1;
    }

    protected void load(String filename) throws IOException {
        String line;
        InputStream stream = EarthGravitationalModel.class.getResourceAsStream(filename);
        if (stream == null) {
            throw new FileNotFoundException(filename);
        }
        LineNumberReader in = new LineNumberReader(new InputStreamReader(stream, "ISO-8859-1"));
        while ((line = in.readLine()) != null) {
            StringTokenizer tokens = new StringTokenizer(line);
            try {
                short n = Short.parseShort(tokens.nextToken());
                short m = Short.parseShort(tokens.nextToken());
                double cbar = Double.parseDouble(tokens.nextToken());
                double sbar = Double.parseDouble(tokens.nextToken());
                if (n > this.nmax) continue;
                int ll = EarthGravitationalModel.locatingArray(n) + m;
                this.cnmGeopCoef[ll] = cbar;
                this.snmGeopCoef[ll] = sbar;
            }
            catch (RuntimeException cause) {
                IOException exception = new IOException(Errors.format((int)4, (Object)filename, (Object)in.getLineNumber()));
                exception.initCause(cause);
                throw exception;
            }
        }
        in.close();
        this.initialize();
    }

    private final void initialize() {
        int i;
        if (this.wgs84) {
            double[] c2n = new double[6];
            c2n[1] = this.c2;
            int sign = 1;
            double esqi = this.esq;
            for (int i2 = 2; i2 < c2n.length; ++i2) {
                c2n[i2] = (double)(sign *= -1) * (3.0 * (esqi *= this.esq)) / (double)((2 * i2 + 1) * (2 * i2 + 3)) * ((double)(1 - i2) + (double)(5 * i2) * this.c2 / this.esq);
            }
            this.cnmGeopCoef[3] = this.cnmGeopCoef[3] + c2n[1] / 2.23606797749979;
            this.cnmGeopCoef[10] = this.cnmGeopCoef[10] + c2n[2] / 3.0;
            this.cnmGeopCoef[21] = this.cnmGeopCoef[21] + c2n[3] / 3.605551275463989;
            if (this.nmax > 6) {
                this.cnmGeopCoef[36] = this.cnmGeopCoef[36] + c2n[4] / 4.123105625617661;
            }
            if (this.nmax > 9) {
                this.cnmGeopCoef[55] = this.cnmGeopCoef[55] + c2n[5] / 4.58257569495584;
            }
        } else {
            this.cnmGeopCoef[3] = this.cnmGeopCoef[3] + 4.841732E-4;
            this.cnmGeopCoef[10] = this.cnmGeopCoef[10] + -7.8305E-7;
        }
        for (i = 0; i <= this.nmax; ++i) {
            this.as[i] = -Math.sqrt(1.0 + 1.0 / (double)(2 * (i + 1)));
        }
        for (i = 0; i <= this.nmax; ++i) {
            for (int j = i + 1; j <= this.nmax; ++j) {
                int ll = EarthGravitationalModel.locatingArray(j) + i;
                int n = 2 * j + 1;
                int ji = (j - i) * (j + i);
                this.aClenshaw[ll] = Math.sqrt((double)(n * (2 * j - 1)) / (double)ji);
                this.bClenshaw[ll] = Math.sqrt((double)(n * (j + i - 1) * (j - i - 1)) / (double)(ji * (2 * j - 3)));
            }
        }
    }

    public double heightOffset(double longitude, double latitude, double height) throws TransformException {
        double phi = Math.toRadians(latitude);
        double sin_phi = Math.sin(phi);
        double sin2_phi = sin_phi * sin_phi;
        double rni = Math.sqrt(1.0 - this.esq * sin2_phi);
        double rn = this.semiMajor / rni;
        double t22 = (rn + height) * Math.cos(phi);
        double x2y2 = t22 * t22;
        double z1 = (rn * (1.0 - this.esq) + height) * sin_phi;
        double th = 1.5707963267948966 - Math.atan(z1 / Math.sqrt(x2y2));
        double y = Math.sin(th);
        double t = Math.cos(th);
        double f1 = this.semiMajor / Math.sqrt(x2y2 + z1 * z1);
        double f2 = f1 * f1;
        double rlam = Math.toRadians(longitude);
        double gravn = this.wgs84 ? this.grava * (1.0 + this.star * sin2_phi) / rni : this.grava * (1.0 + this.star * sin2_phi) + 2.3461E-5 * (sin2_phi * sin2_phi);
        this.sr[0] = 0.0;
        this.sr[1] = Math.sin(rlam);
        this.cr[0] = 1.0;
        this.cr[1] = Math.cos(rlam);
        for (int j = 2; j <= this.nmax; ++j) {
            this.sr[j] = 2.0 * this.cr[1] * this.sr[j - 1] - this.sr[j - 2];
            this.cr[j] = 2.0 * this.cr[1] * this.cr[j - 1] - this.cr[j - 2];
        }
        double sht = 0.0;
        double previousSht = 0.0;
        for (int i = this.nmax; i >= 0; --i) {
            for (int j = this.nmax; j >= i; --j) {
                int ll = EarthGravitationalModel.locatingArray(j) + i;
                int ll2 = ll + j + 1;
                int ll3 = ll2 + j + 2;
                double ta = this.aClenshaw[ll2] * f1 * t;
                double tb = this.bClenshaw[ll3] * f2;
                this.s11[j] = ta * this.s11[j + 1] - tb * this.s11[j + 2] + this.cnmGeopCoef[ll];
                this.s12[j] = ta * this.s12[j + 1] - tb * this.s12[j + 2] + this.snmGeopCoef[ll];
            }
            previousSht = sht;
            sht = -this.as[i] * y * f1 * sht + this.s11[i] * this.cr[i] + this.s12[i] * this.sr[i];
        }
        return ((this.s11[0] + this.s12[0]) * f1 + previousSht * 1.7320508075688772 * y * f2) * this.rkm / (this.semiMajor * (gravn - height * 3.086E-6));
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        return new ParameterGroup(this.getParameterDescriptors(), (GeneralParameterValue[])new ParameterValue[]{new Parameter(Provider.ORDER, (Object)this.nmax)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Provider
    extends MathTransformProvider {
        public static final ParameterDescriptor<Integer> ORDER = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)231))), (int)180, (int)2, (int)180, (boolean)false);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)230))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{ORDER});

        public Provider() {
            super(3, 3, PARAMETERS);
        }

        public Class<? extends Transformation> getOperationType() {
            return Transformation.class;
        }

        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
            int nmax = Provider.intValue(ORDER, (ParameterValueGroup)values);
            if (nmax == 0) {
                nmax = 180;
            }
            EarthGravitationalModel mt = new EarthGravitationalModel(nmax, true);
            String filename = "EGM180.nor";
            try {
                mt.load("EGM180.nor");
            }
            catch (IOException e) {
                throw new FactoryException(Errors.format((int)163, (Object)"EGM180.nor"), (Throwable)e);
            }
            return mt;
        }
    }
}

