/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.io.File;
import java.util.HashMap;
import junit.framework.TestCase;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LabelOrientationTest
extends TestCase {
    private static final long TIME = 10000L;
    FeatureSource<SimpleFeatureType, SimpleFeature> fs;
    ReferencedEnvelope bounds;
    StreamingRenderer renderer;

    protected void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)((Object)this), (String)"diaglines.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("diaglines");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer = new StreamingRenderer();
        HashMap<String, LabelCacheImpl> rendererParams = new HashMap<String, LabelCacheImpl>();
        LabelCacheImpl labelCache = new LabelCacheImpl();
        rendererParams.put("labelCache", labelCache);
        this.renderer.setRendererHints(rendererParams);
        this.renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
    }

    public void testLabelNatural() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textNaturalOrientation.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer(this.fs, style);
        this.renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("Lines with circl stroke", this.renderer, 10000L, this.bounds);
    }

    public void testLabelLineOrientation() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textLineOrientation.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer(this.fs, style);
        this.renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("Lines with circl stroke", this.renderer, 10000L, this.bounds);
    }
}

