/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.io.File;
import java.net.URL;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;

public class RenderingBufferExtractorTest {
    StyleBuilder sb = new StyleBuilder();

    @Test
    public void testNoStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createTextSymbolizer());
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        Assert.assertEquals((long)0L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
        rbe.visit(style);
        Assert.assertEquals((long)0L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testSimpleStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(10.0)));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)10L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testSimpleGraphic() {
        PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, this.sb.createMark("circle"), null));
        ps.getGraphic().setSize(this.sb.literalExpression(15));
        Style style = this.sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)15L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testReachableExternalGraphic() {
        URL resource = TestData.getResource((Object)this, (String)"draw.png");
        PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, null, (Symbol)this.sb.createExternalGraphic(resource, "image/png")));
        ps.getGraphic().setSize(this.sb.literalExpression(null));
        Style style = this.sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)24L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testUnreachableExternalGraphic() throws Exception {
        File file = new File(TestData.getResource((Object)this, (String)"draw.png").toURI());
        URL resource = new File(file.getParent(), "draw-not-there.png").toURI().toURL();
        PointSymbolizer ps = this.sb.createPointSymbolizer(this.sb.createGraphic(null, null, (Symbol)this.sb.createExternalGraphic(resource, "image/png")));
        ps.getGraphic().setSize(this.sb.literalExpression(null));
        Style style = this.sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)0L, (long)rbe.getBuffer());
        Assert.assertFalse((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testNonIntegerStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(10.8)));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)11L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testMultiSymbolizers() {
        LineSymbolizer ls = this.sb.createLineSymbolizer(this.sb.createStroke(10.8));
        PolygonSymbolizer ps = this.sb.createPolygonSymbolizer(this.sb.createStroke(12.0), this.sb.createFill());
        Rule r = this.sb.createRule(new Symbolizer[]{ls, ps});
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(r);
        Assert.assertEquals((long)12L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testPropertyWidth() {
        LineSymbolizer ls = this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), this.sb.attributeExpression("gimbo")));
        PolygonSymbolizer ps = this.sb.createPolygonSymbolizer(this.sb.createStroke(12.0), this.sb.createFill());
        Rule r = this.sb.createRule(new Symbolizer[]{ls, ps});
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(r);
        Assert.assertEquals((long)12L, (long)rbe.getBuffer());
        Assert.assertTrue((!rbe.isEstimateAccurate() ? 1 : 0) != 0);
    }

    @Test
    public void testLiteralParseStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), this.sb.literalExpression("10.0"))));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)10L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testNpePreventionStroke() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(this.sb.colorExpression(Color.BLACK), this.sb.literalExpression(null))));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(style);
        Assert.assertEquals((long)1L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }

    @Test
    public void testLiteralParseGraphics() {
        Graphic g = this.sb.createGraphic();
        g.setSize(this.sb.literalExpression("10.0"));
        MetaBufferEstimator rbe = new MetaBufferEstimator();
        rbe.visit(g);
        Assert.assertEquals((long)10L, (long)rbe.getBuffer());
        Assert.assertTrue((boolean)rbe.isEstimateAccurate());
    }
}

