/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;

public class GeographicHandlerFactory
implements ProjectionHandlerFactory {
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope) {
        CoordinateReferenceSystem crs = renderingEnvelope.getCoordinateReferenceSystem();
        if (renderingEnvelope != null && crs instanceof GeographicCRS) {
            GeographicCRS geogCrs = (GeographicCRS)crs;
            double centralMeridian = geogCrs.getDatum().getPrimeMeridian().getGreenwichLongitude();
            return new WrappingProjectionHandler(renderingEnvelope, null, centralMeridian);
        }
        return null;
    }
}

