/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.HistogramDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1D;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.GenericPiecewise;
import org.geotools.referencing.piecewise.MathTransform1DAdapter;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

class ContrastEnhancementNode
extends StyleVisitorCoverageProcessingNodeAdapter
implements StyleVisitor,
CoverageProcessingNode {
    private static final double MIN_VALUE = 0.0;
    private static final double MAX_VALUE = 1.0;
    private static final Set<String> SUPPORTED_HE_ALGORITHMS;
    private String type = null;
    private double gammaValue = Double.NaN;

    public InternationalString getName() {
        return Vocabulary.formatInternational(6);
    }

    public synchronized void visit(ContrastEnhancement ce) {
        Number number;
        Expression gamma;
        String type;
        if (ce == null) {
            return;
        }
        Expression expType = ce.getType();
        if (expType != null && (type = (String)expType.evaluate(null, String.class)) != null) {
            this.type = type.toUpperCase();
            if (!SUPPORTED_HE_ALGORITHMS.contains(type.toUpperCase())) {
                throw new IllegalArgumentException(Errors.format(11, type.toUpperCase()));
            }
        }
        if ((gamma = ce.getGammaValue()) != null && (number = (Number)gamma.evaluate(null, Double.class)) != null) {
            this.gammaValue = number.doubleValue();
            if (this.gammaValue < 0.0) {
                throw new IllegalArgumentException(Errors.format(10, "Gamma", number));
            }
            if (Double.isNaN(this.gammaValue) || Double.isInfinite(this.gammaValue)) {
                throw new IllegalArgumentException(Errors.format(10, "Gamma", number));
            }
        }
    }

    public ContrastEnhancementNode() {
        this((Hints)null);
    }

    public ContrastEnhancementNode(Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ContrastEnhancementNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies ContrastEnhancement following SLD 1.0 spec."));
    }

    protected GridCoverage2D execute() {
        assert (Thread.holdsLock(this));
        Hints hints = this.getHints();
        List<CoverageProcessingNode> sources = this.getSources();
        if (sources != null && !sources.isEmpty()) {
            GridCoverage2D output;
            GridCoverage2D source = (GridCoverage2D)this.getSource(0).getOutput();
            ContrastEnhancementNode.ensureSourceNotNull(source, this.getName().toString());
            if (!Double.isNaN(this.gammaValue) && !Double.isInfinite(this.gammaValue) && !(Math.abs(this.gammaValue - 1.0) < 1.0E-6) || this.type != null && this.type.length() > 0) {
                boolean intensity;
                RenderedImage sourceImage = source.getRenderedImage();
                RenderedImage initialImage = this.type != null && this.type.equalsIgnoreCase("HISTOGRAM") ? new ImageWorker(sourceImage).setRenderingHints((RenderingHints)hints).forceComponentColorModel().rescaleToBytes().getRenderedImage() : new ImageWorker(sourceImage).setRenderingHints((RenderingHints)hints).forceComponentColorModel().getRenderedImage();
                int numbands = initialImage.getSampleModel().getNumBands();
                RenderedImage alphaBand = null;
                if (numbands % 2 == 0) {
                    alphaBand = new ImageWorker(initialImage).setRenderingHints((RenderingHints)hints).retainLastBand().getRenderedImage();
                    initialImage = new ImageWorker(initialImage).setRenderingHints((RenderingHints)hints).retainBands(numbands - 1).getRenderedImage();
                }
                RenderedImage intensityImage = null;
                RenderedImage hChannel = null;
                RenderedImage sChannel = null;
                RenderedImage IHS = null;
                if (numbands > 1) {
                    IHS = new ImageWorker(initialImage).setRenderingHints((RenderingHints)hints).forceColorSpaceIHS().getRenderedImage();
                    intensityImage = new ImageWorker(IHS).setRenderingHints((RenderingHints)hints).retainFirstBand().getRenderedImage();
                    sChannel = new ImageWorker(IHS).setRenderingHints((RenderingHints)hints).retainLastBand().getRenderedImage();
                    hChannel = new ImageWorker(IHS).setRenderingHints((RenderingHints)hints).retainBands(new int[]{1}).getRenderedImage();
                    intensity = true;
                } else {
                    intensityImage = initialImage;
                    intensity = false;
                }
                RenderedImage heImage = this.performContrastEnhancement(intensityImage, hints);
                RenderedImage finalImage = this.performGammaCorrection(heImage, hints);
                if (intensity) {
                    ImageLayout imageLayout = new ImageLayout();
                    imageLayout.setColorModel(IHS.getColorModel());
                    imageLayout.setSampleModel(IHS.getSampleModel());
                    RenderingHints rendHints = new RenderingHints(Collections.EMPTY_MAP);
                    rendHints.add((RenderingHints)hints);
                    rendHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
                    ParameterBlock pb = new ParameterBlock();
                    pb.addSource(finalImage);
                    pb.addSource(hChannel);
                    pb.addSource(sChannel);
                    finalImage = JAI.create((String)"bandmerge", (ParameterBlock)pb, (RenderingHints)rendHints);
                    finalImage = new ImageWorker(finalImage).setRenderingHints((RenderingHints)hints).forceColorSpaceRGB().getRenderedImage();
                }
                if (alphaBand != null) {
                    int[] nArray;
                    ColorSpace colorSpace = numbands >= 3 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
                    if (numbands >= 3) {
                        int[] nArray2 = new int[4];
                        nArray2[0] = 8;
                        nArray2[1] = 8;
                        nArray2[2] = 8;
                        nArray = nArray2;
                        nArray2[3] = 8;
                    } else {
                        int[] nArray3 = new int[2];
                        nArray3[0] = 8;
                        nArray = nArray3;
                        nArray3[1] = 8;
                    }
                    ComponentColorModel cm = new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
                    ImageLayout imageLayout = new ImageLayout();
                    imageLayout.setColorModel((ColorModel)cm);
                    imageLayout.setSampleModel(((ColorModel)cm).createCompatibleSampleModel(finalImage.getWidth(), finalImage.getHeight()));
                    finalImage = new ImageWorker(finalImage).setRenderingHints((RenderingHints)hints).setRenderingHint(JAI.KEY_IMAGE_LAYOUT, (Object)imageLayout).addBand(alphaBand, false).getRenderedOperation();
                }
                int numSourceBands = source.getNumSampleDimensions();
                int numActualBands = finalImage.getSampleModel().getNumBands();
                if (numActualBands == numSourceBands) {
                    output = this.getCoverageFactory().create((CharSequence)("ce_coverage" + source.getName().toString()), finalImage, source.getGridGeometry(), source.getSampleDimensions(), new GridCoverage[]{source}, new HashMap(source.getProperties()));
                } else {
                    GridSampleDimension[] sd = new GridSampleDimension[numActualBands];
                    for (int i = 0; i < numActualBands; ++i) {
                        sd[i] = source.getSampleDimension(0);
                    }
                    output = this.getCoverageFactory().create((CharSequence)("ce_coverage" + source.getName().toString()), finalImage, source.getGridGeometry(), sd, new GridCoverage[]{source}, new HashMap(source.getProperties()));
                }
            } else {
                output = source;
            }
            return output;
        }
        throw new IllegalStateException(Errors.format(3, this.getName().toString()));
    }

    private RenderedImage performContrastEnhancement(RenderedImage inputImage, Hints hints) {
        if (this.type != null && this.type.length() > 0) {
            assert (inputImage.getSampleModel().getNumBands() == 1) : inputImage;
            int dataType = inputImage.getSampleModel().getDataType();
            if (this.type.equalsIgnoreCase("NORMALIZE")) {
                RenderedOp image = ExtremaDescriptor.create((RenderedImage)inputImage, null, (Integer)1, (Integer)1, null, (Integer)1, null);
                double[][] extrema = (double[][])image.getProperty("extrema");
                int numBands = extrema[0].length;
                assert (numBands == 1) : image;
                if (dataType == 0) {
                    if (extrema[1][0] == 255.0 && extrema[0][0] == 0.0) {
                        return inputImage;
                    }
                    double delta = extrema[1][0] - extrema[0][0];
                    double scale = 255.0 / delta;
                    double offset = -scale * extrema[0][0];
                    byte[] lut = new byte[256];
                    for (int i = 1; i < lut.length; ++i) {
                        lut[i] = (byte)(scale * (double)i + offset + 0.5);
                    }
                    LookupTableJAI lookup = new LookupTableJAI(lut);
                    ParameterBlock pb = new ParameterBlock();
                    pb.addSource(inputImage);
                    pb.add(lookup);
                    return JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)hints);
                }
                double maximum = ColorUtilities.getMaximum((int)dataType);
                double minimum = ColorUtilities.getMinimum((int)dataType);
                if (extrema[1][0] == maximum && extrema[0][0] == minimum) {
                    return inputImage;
                }
                double delta = extrema[1][0] - extrema[0][0];
                double scale = (maximum - minimum) / delta;
                double offset = minimum - scale * extrema[0][0];
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(inputImage);
                pb.add(new double[]{scale});
                pb.add(new double[]{offset});
                return JAI.create((String)"rescale", (ParameterBlock)pb, (RenderingHints)hints);
            }
            if (this.type.equalsIgnoreCase("EXPONENTIAL")) {
                if (dataType == 0) {
                    byte[] lut = new byte[256];
                    double normalizationFactor = 255.0;
                    double correctionFactor = 148.40406025167826;
                    for (int i = 1; i < lut.length; ++i) {
                        lut[i] = (byte)(0.5 + 148.40406025167826 * (Math.exp((double)i / 255.0) - 1.0));
                    }
                    return LookupDescriptor.create((RenderedImage)inputImage, (LookupTableJAI)new LookupTableJAI(lut), (RenderingHints)hints);
                }
                RenderedOp statistics = ExtremaDescriptor.create((RenderedImage)inputImage, null, (Integer)1, (Integer)1, null, (Integer)1, null);
                double[] minimum = (double[])statistics.getProperty("minimum");
                double[] maximum = (double[])statistics.getProperty("maximum");
                final double normalizationFactor = maximum[0];
                final double correctionFactor = normalizationFactor / 1.718281828459045;
                DefaultPiecewiseTransform1DElement mainElement = DefaultPiecewiseTransform1DElement.create("exponential-contrast-enhancement-transform", (NumberRange<? extends Number>)NumberRange.create((double)minimum[0], (double)maximum[0]), new MathTransform1DAdapter(){

                    public double derivative(double value) throws TransformException {
                        throw new UnsupportedOperationException(Errors.format(15));
                    }

                    public boolean isIdentity() {
                        return false;
                    }

                    public double transform(double value) throws TransformException {
                        value = correctionFactor * (Math.exp(value / normalizationFactor) - 1.0);
                        return value;
                    }
                });
                DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
                ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.GenericPiecewise");
                pbj.addSource((Object)inputImage);
                pbj.setParameter("Domain1D", (Object)transform);
                pbj.setParameter("bandIndex", (Object)0);
                return JAI.create((String)"org.geotools.GenericPiecewise", (ParameterBlock)pbj);
            }
            if (this.type.equalsIgnoreCase("LOGARITHMIC")) {
                if (dataType == 0) {
                    byte[] lut = new byte[256];
                    double normalizationFactor = 255.0;
                    double correctionFactor = 100.0;
                    for (int i = 1; i < lut.length; ++i) {
                        lut[i] = (byte)(0.5 + 255.0 * Math.log((double)i * 100.0 / 255.0 + 1.0));
                    }
                    return LookupDescriptor.create((RenderedImage)inputImage, (LookupTableJAI)new LookupTableJAI(lut), (RenderingHints)hints);
                }
                RenderedOp statistics = ExtremaDescriptor.create((RenderedImage)inputImage, null, (Integer)1, (Integer)1, null, (Integer)1, null);
                double[] minimum = (double[])statistics.getProperty("minimum");
                double[] maximum = (double[])statistics.getProperty("maximum");
                final double normalizationFactor = maximum[0];
                double correctionFactor = 100.0;
                DefaultPiecewiseTransform1DElement mainElement = DefaultPiecewiseTransform1DElement.create("logarithmic-contrast-enhancement-transform", (NumberRange<? extends Number>)NumberRange.create((double)minimum[0], (double)maximum[0]), new MathTransform1DAdapter(){

                    public double derivative(double value) throws TransformException {
                        throw new UnsupportedOperationException(Errors.format(15));
                    }

                    public boolean isIdentity() {
                        return false;
                    }

                    public double transform(double value) throws TransformException {
                        value = normalizationFactor * Math.log(1.0 + value * 100.0 / normalizationFactor);
                        return value;
                    }
                });
                DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
                ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.GenericPiecewise");
                pbj.addSource((Object)inputImage);
                pbj.setParameter("Domain1D", (Object)transform);
                pbj.setParameter("bandIndex", (Object)0);
                return JAI.create((String)"org.geotools.GenericPiecewise", (ParameterBlock)pbj);
            }
            if (this.type.equalsIgnoreCase("HISTOGRAM")) {
                inputImage = new ImageWorker(inputImage).rescaleToBytes().getRenderedImage();
                RenderedOp hist = HistogramDescriptor.create((RenderedImage)inputImage, null, (Integer)1, (Integer)1, (int[])new int[]{256}, (double[])new double[]{0.0}, (double[])new double[]{256.0}, null);
                Histogram h = (Histogram)hist.getProperty("histogram");
                byte[] cumulative = new byte[h.getNumBins(0)];
                float totalBinSum = 0.0f;
                for (int i = 0; i < cumulative.length; ++i) {
                    totalBinSum += (float)h.getBinSize(0, i);
                }
                float scale = (float)(h.getHighValue(0) - 1.0 - h.getLowValue(0)) / totalBinSum;
                float sum = 0.0f;
                for (int i = 1; i < cumulative.length; ++i) {
                    cumulative[i] = (byte)((double)((sum += (float)h.getBinSize(0, i - 1)) * scale) + h.getLowValue(0) + 0.5);
                }
                LookupTableJAI lookup = new LookupTableJAI(cumulative);
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(hist);
                pb.add(lookup);
                return JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)hints);
            }
        }
        return inputImage;
    }

    private RenderedImage performGammaCorrection(RenderedImage inputImage, Hints hints) {
        assert (inputImage.getSampleModel().getNumBands() == 1) : inputImage;
        int dataType = inputImage.getSampleModel().getDataType();
        RenderedImage result = inputImage;
        if (!Double.isNaN(this.gammaValue) && Math.abs(this.gammaValue - 1.0) > 1.0E-6) {
            if (dataType == 0) {
                byte[] lut = new byte[256];
                for (int i = 1; i < lut.length; ++i) {
                    lut[i] = (byte)(255.0 * Math.pow((double)i / 255.0, this.gammaValue) + 0.5);
                }
                LookupTableJAI lookup = new LookupTableJAI(lut);
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(inputImage);
                pb.add(lookup);
                result = JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)hints);
            } else {
                RenderedOp statistics = ExtremaDescriptor.create((RenderedImage)inputImage, null, (Integer)1, (Integer)1, null, (Integer)1, null);
                double[] minimum = (double[])statistics.getProperty("minimum");
                double[] maximum = (double[])statistics.getProperty("maximum");
                final double scale = (maximum[0] - minimum[0]) / 1.0;
                final double offset = minimum[0] - 0.0 * scale;
                DefaultPiecewiseTransform1DElement mainElement = DefaultPiecewiseTransform1DElement.create("gamma-correction-transform", (NumberRange<? extends Number>)NumberRange.create((double)minimum[0], (double)maximum[0]), new MathTransform1DAdapter(){

                    public double derivative(double value) throws TransformException {
                        throw new UnsupportedOperationException(Errors.format(15));
                    }

                    public boolean isIdentity() {
                        return false;
                    }

                    public double transform(double value) throws TransformException {
                        value = (value - offset) / scale;
                        return offset + Math.pow(value, ContrastEnhancementNode.this.gammaValue) * scale;
                    }
                });
                DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
                ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.GenericPiecewise");
                pbj.addSource((Object)inputImage);
                pbj.setParameter("Domain1D", (Object)transform);
                pbj.setParameter("bandIndex", (Object)0);
                result = JAI.create((String)"org.geotools.GenericPiecewise", (ParameterBlock)pbj);
            }
        }
        assert (result.getSampleModel().getNumBands() == 1) : result;
        return result;
    }

    static {
        HashSet<String> heAlg = new HashSet<String>(2, 1.0f);
        heAlg.add("NORMALIZE");
        heAlg.add("HISTOGRAM");
        heAlg.add("LOGARITHMIC");
        heAlg.add("EXPONENTIAL");
        SUPPORTED_HE_ALGORITHMS = Collections.unmodifiableSet(heAlg);
        try {
            new ParameterBlockJAI("org.geotools.GenericPiecewise");
        }
        catch (Exception e) {
            GenericPiecewise.register(JAI.getDefaultInstance());
        }
    }
}

