/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.io.IOException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.Layer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultMapContextTest {
    @Test
    public void testDispose() {
        DefaultMapContext mapContext = new DefaultMapContext();
        mapContext.dispose();
        mapContext = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mapContext.dispose();
    }

    @Test
    public void testNPELayerBounds() throws IOException {
        MapLayer mapLayerBoundsNull = new MapLayer(new Layer(){

            public ReferencedEnvelope getBounds() {
                return null;
            }
        });
        DefaultMapContext mapContext = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mapContext.addLayer(mapLayerBoundsNull);
        ReferencedEnvelope layerBounds = mapContext.getLayerBounds();
        Assert.assertNull((Object)layerBounds);
        ReferencedEnvelope maxBounds = mapContext.getMaxBounds();
        Assert.assertNotNull((Object)maxBounds);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)maxBounds.getCoordinateReferenceSystem());
        Assert.assertTrue((boolean)maxBounds.isEmpty());
    }
}

