/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageReader;
import it.geosolutions.imageio.plugins.arcgrid.spi.AsciiGridsImageReaderSpi;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ExtremaDescriptor;
import junit.framework.Assert;
import org.geotools.TestData;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.piecewise.DefaultConstantPiecewiseTransformElement;
import org.geotools.referencing.piecewise.DefaultLinearPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.DefaultPassthroughPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1D;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1DElement;
import org.geotools.referencing.piecewise.GenericPiecewise;
import org.geotools.referencing.piecewise.MathTransform1DAdapter;
import org.geotools.referencing.piecewise.PiecewiseUtilities;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerTest;
import org.geotools.util.NumberRange;
import org.junit.Before;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class TestPiecewise {
    @Test
    public void linearTransform() throws IOException, TransformException {
        DefaultPiecewiseTransform1DElement e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (NumberRange)NumberRange.create((int)0, (int)100), (NumberRange)NumberRange.create((int)0, (int)200));
        Assert.assertTrue((boolean)(e0 instanceof DefaultLinearPiecewiseTransform1DElement));
        Assert.assertEquals((double)((DefaultLinearPiecewiseTransform1DElement)e0).getOutputMinimum(), (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)((DefaultLinearPiecewiseTransform1DElement)e0).getOutputMaximum(), (double)e0.transform(e0.getInputMaximum()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DefaultLinearPiecewiseTransform1DElement)e0).getOffset(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)((DefaultLinearPiecewiseTransform1DElement)e0).getScale(), (double)0.0);
        Assert.assertFalse((boolean)e0.isIdentity());
        Assert.assertEquals((int)1, (int)e0.getSourceDimensions());
        Assert.assertEquals((int)1, (int)e0.getTargetDimensions());
        try {
            Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        try {
            Assert.assertFalse((boolean)transform.isIdentity());
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((int)1, (int)transform.getSourceDimensions());
        Assert.assertEquals((int)1, (int)transform.getTargetDimensions());
    }

    @Test
    public void mathTransform1DAdapter() throws IOException, TransformException {
        MathTransform1DAdapter defaultAdapter = new MathTransform1DAdapter();
        Assert.assertEquals((int)defaultAdapter.getSourceDimensions(), (int)1);
        Assert.assertEquals((int)defaultAdapter.getTargetDimensions(), (int)1);
        try {
            defaultAdapter.inverse();
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            defaultAdapter.transform(0.0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            defaultAdapter.transform(new double[]{0.0}, 0, null, 0, 1);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            defaultAdapter.transform(new float[]{0.0f}, 0, null, 0, 1);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            defaultAdapter.derivative(0.0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            defaultAdapter.derivative((DirectPosition)new DirectPosition1D(0.0));
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            defaultAdapter.toWKT();
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            defaultAdapter.isIdentity();
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void constantTransform() throws IOException, TransformException {
        DefaultPiecewiseTransform1DElement e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY), (byte)0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            e0.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            transform.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY), (int)0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            e0.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultPiecewiseTransform1D transform1 = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform1.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform1.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            transform1.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)transform.equals((Object)transform1));
        Assert.assertFalse((boolean)transform1.equals((Object)transform));
        Assert.assertFalse((boolean)transform.equals((Object)transform));
        Assert.assertFalse((boolean)transform1.equals((Object)transform1));
        Assert.assertEquals((int)transform1.hashCode(), (int)transform.hashCode());
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY), (double)0.0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            e0.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            transform.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (NumberRange)NumberRange.create((int)3, (int)3), (double)0.0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(3.0), (double)0.0);
        Assert.assertEquals((double)3.0, (double)e0.inverse().transform((DirectPosition)new DirectPosition1D(0.0), null).getOrdinate(0), (double)0.0);
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)e0.transform(3.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(3.0), (double)0.0, (double)0.0);
    }

    @Test
    public void piecewiseLogarithm() throws IOException, TransformException {
        DefaultPiecewiseTransform1DElement zero = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (NumberRange)NumberRange.create((int)0, (int)0), (int)0);
        DefaultPiecewiseTransform1DElement mainElement = new DefaultPiecewiseTransform1DElement((CharSequence)"natural logarithm", NumberRange.create((int)0, (boolean)false, (int)255, (boolean)true), new MathTransform1D(){

            public double derivative(double arg0) throws TransformException {
                return 1.0 / arg0;
            }

            public double transform(double arg0) throws TransformException {
                return Math.log(arg0);
            }

            public Matrix derivative(DirectPosition arg0) throws MismatchedDimensionException, TransformException {
                return null;
            }

            public int getSourceDimensions() {
                return 1;
            }

            public int getTargetDimensions() {
                return 1;
            }

            public MathTransform1D inverse() throws NoninvertibleTransformException {
                return null;
            }

            public boolean isIdentity() {
                return false;
            }

            public String toWKT() throws UnsupportedOperationException {
                return null;
            }

            public DirectPosition transform(DirectPosition arg0, DirectPosition arg1) throws MismatchedDimensionException, TransformException {
                return null;
            }

            public void transform(double[] arg0, int arg1, double[] arg2, int arg3, int arg4) throws TransformException {
            }

            public void transform(float[] arg0, int arg1, float[] arg2, int arg3, int arg4) throws TransformException {
            }

            public void transform(float[] arg0, int arg1, double[] arg2, int arg3, int arg4) throws TransformException {
            }

            public void transform(double[] arg0, int arg1, float[] arg2, int arg3, int arg4) throws TransformException {
            }
        });
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)transform.transform(1.0), (double)0.0);
        Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(255.0), (double)0.0);
        Assert.assertEquals((double)Math.log(124.0), (double)transform.transform(124.0), (double)0.0);
        try {
            Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(256.0), (double)0.0);
            Assert.assertTrue((boolean)false);
        }
        catch (TransformException transformException) {
            // empty catch block
        }
        DefaultPiecewiseTransform1DElement nodata = DefaultPiecewiseTransform1DElement.create((CharSequence)"no-data", (NumberRange)NumberRange.create((int)-1, (int)-1), (double)Double.NaN);
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement, nodata});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)transform.transform(1.0), (double)0.0);
        Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(255.0), (double)0.0);
        Assert.assertEquals((double)Math.log(124.0), (double)transform.transform(124.0), (double)0.0);
        try {
            Assert.assertTrue((boolean)Double.isNaN(transform.transform(256.0)));
            Assert.assertTrue((boolean)false);
        }
        catch (TransformException e) {
            Assert.assertTrue((boolean)true);
        }
        DefaultPiecewiseTransform1DElement overlap = DefaultPiecewiseTransform1DElement.create((CharSequence)"overlap", (NumberRange)NumberRange.create((int)-100, (int)12), (double)Double.NaN);
        try {
            transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement, overlap, nodata});
            Assert.assertTrue((boolean)false);
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void defaultTransform() throws IOException, TransformException {
        DefaultPiecewiseTransform1DElement t0 = new DefaultPiecewiseTransform1DElement((CharSequence)"t0", NumberRange.create((double)0.0, (boolean)true, (double)1.0, (boolean)true), PiecewiseUtilities.createLinearTransform1D((NumberRange)NumberRange.create((double)0.0, (boolean)true, (double)1.0, (boolean)true), (NumberRange)NumberRange.create((int)200, (int)201)));
        Assert.assertEquals((double)t0.transform(0.5), (double)200.5, (double)0.0);
        Assert.assertTrue((boolean)t0.contains(0.5));
        Assert.assertTrue((boolean)t0.contains(NumberRange.create((double)0.1, (double)0.9)));
        Assert.assertFalse((boolean)t0.contains(1.5));
        Assert.assertFalse((boolean)t0.contains(NumberRange.create((double)0.1, (double)1.9)));
        Assert.assertTrue((boolean)t0.equals((Object)t0));
        Assert.assertEquals((double)t0.transform((DirectPosition)new GeneralDirectPosition(new double[]{0.5}), null).getOrdinate(0), (double)200.5, (double)0.0);
        Assert.assertEquals((double)t0.inverse().transform((DirectPosition)new GeneralDirectPosition(new double[]{200.5}), null).getOrdinate(0), (double)0.5, (double)0.0);
        Assert.assertEquals((double)t0.derivative(1.0), (double)1.0, (double)0.0);
        t0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"t0", (NumberRange)NumberRange.create((double)0.0, (boolean)true, (double)1.0, (boolean)true), (NumberRange)NumberRange.create((int)200, (int)201));
        Assert.assertFalse((boolean)t0.equals((Object)DefaultPiecewiseTransform1DElement.create((CharSequence)"t0", (NumberRange)NumberRange.create((double)0.0, (boolean)true, (double)1.0, (boolean)true), (NumberRange)NumberRange.create((int)200, (int)202))));
        Assert.assertEquals((double)t0.transform(0.5), (double)200.5, (double)0.0);
        Assert.assertEquals((double)t0.transform((DirectPosition)new GeneralDirectPosition(new double[]{0.5}), null).getOrdinate(0), (double)200.5, (double)0.0);
        Assert.assertEquals((double)t0.inverse().transform((DirectPosition)new GeneralDirectPosition(new double[]{200.5}), null).getOrdinate(0), (double)0.5, (double)0.0);
        Assert.assertEquals((double)t0.derivative(1.0), (double)1.0, (double)0.0);
        DefaultPiecewiseTransform1DElement t1 = DefaultPiecewiseTransform1DElement.create((CharSequence)"t1", (NumberRange)NumberRange.create((double)1.0, (boolean)false, (double)2.0, (boolean)true), (int)201);
        Assert.assertEquals((double)t1.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform(1.6), (double)201.0, (double)0.0);
        Assert.assertFalse((boolean)t0.equals((Object)t1));
        Assert.assertEquals((double)t1.transform((DirectPosition)new GeneralDirectPosition(new double[]{1.8}), null).getOrdinate(0), (double)201.0, (double)0.0);
        try {
            Assert.assertEquals((double)t1.inverse().transform((DirectPosition)new GeneralDirectPosition(new double[]{201.0}), null).getOrdinate(0), (double)0.5, (double)0.0);
            Assert.assertTrue((boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((double)t1.derivative(2.0), (double)0.0, (double)0.0);
        t1 = new DefaultConstantPiecewiseTransformElement((CharSequence)"t1", NumberRange.create((double)1.0, (boolean)false, (double)2.0, (boolean)true), 201);
        Assert.assertEquals((double)t1.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform(1.6), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform((DirectPosition)new GeneralDirectPosition(new double[]{1.8}), null).getOrdinate(0), (double)201.0, (double)0.0);
        try {
            Assert.assertEquals((double)t1.inverse().transform((DirectPosition)new GeneralDirectPosition(new double[]{201.0}), null).getOrdinate(0), (double)0.5, (double)0.0);
            Assert.assertTrue((boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((double)t1.derivative(2.0), (double)0.0, (double)0.0);
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{t1}, 12.0);
        Assert.assertEquals((String)transform.getName().toString(), (String)t1.getName().toString());
        Assert.assertEquals((double)transform.getApproximateDomainRange().getMinimum(), (double)1.0, (double)0.0);
        Assert.assertEquals((double)transform.getApproximateDomainRange().getMaximum(), (double)2.0, (double)0.0);
        Assert.assertEquals((double)transform.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)transform.transform((DirectPosition)new GeneralDirectPosition(new double[]{1.5}), null).getOrdinate(0), (double)201.0, (double)0.0);
        Assert.assertEquals((double)transform.transform(2.5), (double)0.0, (double)12.0);
        try {
            transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"", (NumberRange)NumberRange.create((int)0, (int)100), (NumberRange)NumberRange.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY))});
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void passthroughTransform() throws IOException, TransformException {
        DefaultPassthroughPiecewiseTransform1DElement p0 = new DefaultPassthroughPiecewiseTransform1DElement((CharSequence)"p0", NumberRange.create((double)0.0, (boolean)true, (double)1.0, (boolean)true));
        Assert.assertEquals((int)p0.getTargetDimensions(), (int)1);
        Assert.assertEquals((int)p0.getSourceDimensions(), (int)1);
        Assert.assertTrue((boolean)p0.isIdentity());
        Assert.assertEquals((Object)p0.inverse(), (Object)LinearTransform1D.IDENTITY);
        Assert.assertEquals((double)p0.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p0.transform((DirectPosition)new GeneralDirectPosition(new double[]{0.5}), null).getOrdinate(0), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p0.inverse().transform((DirectPosition)new GeneralDirectPosition(new double[]{0.5}), null).getOrdinate(0), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p0.derivative(1.0), (double)1.0, (double)0.0);
        DirectPosition1D inDP = new DirectPosition1D(0.6);
        DirectPosition outDP = p0.transform((DirectPosition)inDP, null);
        Assert.assertTrue((outDP.getOrdinate(0) == 0.6 ? 1 : 0) != 0);
        try {
            p0.transform(new double[]{0.5}, 0, null, 0, 0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            p0.transform(new float[]{0.5f}, 0, null, 0, 0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            p0.toWKT();
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Matrix m = p0.derivative((DirectPosition)inDP);
        Assert.assertTrue((m.getNumCol() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((m.getNumRow() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((m.getElement(0, 0) == 1.0 ? 1 : 0) != 0);
        DefaultPiecewiseTransform1D piecewise = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{p0}, 11.0);
        Assert.assertEquals((double)piecewise.getApproximateDomainRange().getMinimum(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)piecewise.getApproximateDomainRange().getMaximum(), (double)1.0, (double)0.0);
        Assert.assertEquals((double)piecewise.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)piecewise.transform((DirectPosition)new GeneralDirectPosition(new double[]{0.5}), null).getOrdinate(0), (double)0.5, (double)0.0);
        Assert.assertEquals((double)piecewise.transform(1.5), (double)0.0, (double)11.0);
        try {
            piecewise.transform(new double[]{0.5}, 0, null, 0, 0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            piecewise.transform(new float[]{0.5f}, 0, null, 0, 0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            piecewise.toWKT();
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            m = piecewise.derivative((DirectPosition)inDP);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        DefaultPassthroughPiecewiseTransform1DElement p1 = new DefaultPassthroughPiecewiseTransform1DElement((CharSequence)"p1");
        Assert.assertEquals((int)p1.getTargetDimensions(), (int)1);
        Assert.assertEquals((int)p1.getSourceDimensions(), (int)1);
        Assert.assertTrue((boolean)p1.isIdentity());
        Assert.assertEquals((Object)p1.inverse(), (Object)LinearTransform1D.IDENTITY);
        Assert.assertEquals((double)p1.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p1.transform(111.5), (double)111.5, (double)0.0);
        Assert.assertEquals((double)p1.transform((DirectPosition)new GeneralDirectPosition(new double[]{123.5}), null).getOrdinate(0), (double)123.5, (double)0.0);
        Assert.assertEquals((double)p1.inverse().transform((DirectPosition)new GeneralDirectPosition(new double[]{657.5}), null).getOrdinate(0), (double)657.5, (double)0.0);
        Assert.assertEquals((double)p1.derivative(1.0), (double)1.0, (double)0.0);
        DirectPosition1D inDP1 = new DirectPosition1D(0.6);
        DirectPosition outDP1 = p1.transform((DirectPosition)inDP1, null);
        Assert.assertTrue((outDP1.getOrdinate(0) == 0.6 ? 1 : 0) != 0);
        try {
            p1.transform(new double[]{1233444.5}, 0, null, 0, 0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            p1.transform(new float[]{6595.5f}, 0, null, 0, 0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            p1.toWKT();
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Matrix m1 = p1.derivative((DirectPosition)inDP1);
        Assert.assertTrue((m1.getNumCol() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((m1.getNumRow() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((m1.getElement(0, 0) == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void lookupByte() throws IOException, TransformException {
        RenderedImage image = new ImageWorker((RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)this, (String)"usa.png"))).forceComponentColorModel().retainFirstBand().getRenderedImage();
        if (TestData.isInteractiveTest()) {
            RasterSymbolizerTest.visualize(image, "testLookupByte");
        }
        DefaultPiecewiseTransform1DElement c1 = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"c1", (NumberRange)NumberRange.create((int)1, (int)128), (NumberRange)NumberRange.create((int)1, (int)255));
        DefaultPiecewiseTransform1DElement c0 = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"c0", (NumberRange)NumberRange.create((int)129, (int)255), (NumberRange)NumberRange.create((int)255, (int)255));
        DefaultPiecewiseTransform1DElement nodata = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"nodata", (NumberRange)NumberRange.create((int)0, (int)0), (int)0);
        DefaultPiecewiseTransform1D list = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{c0, c1, nodata});
        ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.GenericPiecewise");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)list);
        RenderedOp finalimage = JAI.create((String)"org.geotools.GenericPiecewise", (ParameterBlock)pbj);
        if (TestData.isInteractiveTest()) {
            RasterSymbolizerTest.visualize((RenderedImage)finalimage, "testLookupByte");
        } else {
            finalimage.getTiles();
        }
    }

    @Test
    public void SWANLOGARITHMIC() throws IOException {
        RenderedImage image = this.getSWAN();
        if (TestData.isInteractiveTest()) {
            RasterSymbolizerTest.visualize(image, "testSWANLOGARITHMIC");
        }
        RenderedOp statistics = ExtremaDescriptor.create((RenderedImage)image, (ROI)new ROI(new ImageWorker(image).binarize(0.0).getRenderedImage()), (Integer)new Integer(1), (Integer)new Integer(1), (Boolean)Boolean.FALSE, (Integer)new Integer(1), null);
        final double[] minimum = (double[])statistics.getProperty("minimum");
        final double[] maximum = (double[])statistics.getProperty("maximum");
        DefaultPiecewiseTransform1DElement mainElement = new DefaultPiecewiseTransform1DElement((CharSequence)"natural logarithm", NumberRange.create((double)minimum[0], (double)maximum[0]), (MathTransform1D)new MathTransform1DAdapter(){

            public double derivative(double arg0) throws TransformException {
                return 1.0 / arg0;
            }

            public double transform(double arg0) throws TransformException {
                return minimum[0] + 1.2 * Math.log(arg0 / minimum[0]) * ((maximum[0] - minimum[0]) / Math.log(maximum[0] / minimum[0]));
            }

            public boolean isIdentity() {
                return false;
            }
        });
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
        ParameterBlockJAI pbj = new ParameterBlockJAI("org.geotools.GenericPiecewise");
        pbj.addSource((Object)image);
        pbj.setParameter("Domain1D", (Object)transform);
        try {
            pbj.setParameter("bandIndex", (Object)new Integer(2));
            RenderedOp d = JAI.create((String)"org.geotools.GenericPiecewise", (ParameterBlock)pbj);
            d.getTiles();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception d) {
            // empty catch block
        }
        pbj.setParameter("bandIndex", (Object)new Integer(0));
        RenderedOp finalImage = JAI.create((String)"org.geotools.GenericPiecewise", (ParameterBlock)pbj);
        if (TestData.isInteractiveTest()) {
            RasterSymbolizerTest.visualize((RenderedImage)finalImage, "testSWANLOGARITHMIC");
        } else {
            finalImage.getTiles();
        }
        finalImage.dispose();
    }

    private RenderedImage getSWAN() throws IOException, FileNotFoundException {
        AsciiGridsImageReader reader = (AsciiGridsImageReader)new AsciiGridsImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(TestData.file((Object)this, (String)"arcgrid/SWAN_NURC_LigurianSeaL07_HSIGN.asc")));
        RenderedImage image = reader.readAsRenderedImage(0, null);
        return image;
    }

    @Before
    public void setUp() throws Exception {
        try {
            new ParameterBlockJAI("org.geotools.GenericPiecewise");
        }
        catch (Exception e) {
            GenericPiecewise.register((JAI)JAI.getDefaultInstance());
        }
        File file = TestData.copy((Object)this, (String)"arcgrid/arcgrid.zip");
        Assert.assertTrue((boolean)file.exists());
        TestData.unzipFile((Object)this, (String)"arcgrid/arcgrid.zip");
    }
}

