/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import javax.imageio.ImageIO;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.CountingRenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;

public class GridCoverageRendererTest {
    String FILENAME = "TestGridCoverage.jpg";

    private final GridCoverage2D getGC() throws IOException, IllegalArgumentException, ParseException {
        String path = "TestGridCoverage.tif";
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        Rectangle2D.Double bounds = new Rectangle2D.Double(35.0, -41.0, 45.0, 46.0);
        GeneralEnvelope envelope = new GeneralEnvelope((Rectangle2D)bounds);
        BufferedImage image = ImageIO.read(TestData.getResource((Object)this, (String)path));
        int numBands = image.getSampleModel().getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        int i = 0;
        while (i < numBands) {
            bands[i] = new GridSampleDimension((CharSequence)("band " + i));
            ++i;
        }
        String filename = new File(path).getName();
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
        return factory.create((CharSequence)filename, (RenderedImage)image, (Envelope)envelope, bands, null, null);
    }

    private static CoordinateReferenceSystem getProjectedCRS(GridCoverage2D coverage) {
        MathTransform mt;
        GeographicCRS base;
        try {
            base = (GeographicCRS)coverage.getCoordinateReferenceSystem();
            Ellipsoid ellipsoid = base.getDatum().getEllipsoid();
            DefaultMathTransformFactory factory = new DefaultMathTransformFactory();
            ParameterValueGroup parameters = factory.getDefaultParameters("Oblique_Stereographic");
            parameters.parameter("semi_major").setValue(ellipsoid.getSemiMajorAxis());
            parameters.parameter("semi_minor").setValue(ellipsoid.getSemiMinorAxis());
            parameters.parameter("central_meridian").setValue(5);
            parameters.parameter("latitude_of_origin").setValue(-5);
            try {
                mt = factory.createParameterizedTransform(parameters);
            }
            catch (FactoryException exception) {
                Assert.fail((String)exception.getLocalizedMessage());
                return null;
            }
        }
        catch (NoSuchIdentifierException exception) {
            Assert.fail((String)exception.getLocalizedMessage());
            return null;
        }
        return new DefaultProjectedCRS(Collections.singletonMap("name", "Stereographic"), base, mt, (CartesianCS)DefaultCartesianCS.PROJECTED);
    }

    @Test
    public void paint() throws Exception {
        GridCoverage2D gc = this.getGC();
        DefaultMapContext context = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Style style = GridCoverageRendererTest.getStyle();
        context.addLayer((GridCoverage)gc, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)context);
        RendererBaseTest.showRender("testGridCoverage", (GTRenderer)renderer, 1000L, context.getLayerBounds());
    }

    @Test
    public void paintWrongStyle() throws Exception {
        GridCoverage2D gc = this.getGC();
        DefaultMapContext context = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Style style = RendererBaseTest.loadStyle(this, "empty.sld");
        context.addLayer((GridCoverage)gc, style);
        StreamingRenderer renderer = new StreamingRenderer();
        CountingRenderListener counter = new CountingRenderListener();
        renderer.addRenderListener((RenderListener)counter);
        renderer.setRendererHints(Collections.singletonMap("optimizedDataLoadingEnabled", Boolean.TRUE));
        renderer.setContext((MapContext)context);
        BufferedImage image = new BufferedImage(300, 300, 6);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        renderer.paint(g2d, new Rectangle(0, 0, 300, 300), context.getLayerBounds());
        g2d.dispose();
        Assert.assertEquals((long)0L, (long)counter.errors);
        Assert.assertEquals((long)1L, (long)counter.features);
    }

    @Test
    public void reproject() throws Exception {
        GridCoverage2D coverage = this.getGC();
        DefaultMapContext context = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Style style = GridCoverageRendererTest.getStyle();
        context.addLayer((GridCoverage)coverage, style);
        CoordinateReferenceSystem destCRS = GridCoverageRendererTest.getProjectedCRS(coverage);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)context);
        ReferencedEnvelope env = context.getLayerBounds();
        env = new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope newbounds = env.transform(destCRS, true);
        RendererBaseTest.showRender("testGridCoverageReprojection", (GTRenderer)renderer, 1000L, newbounds);
    }

    private static Style getStyle() {
        StyleBuilder sb = new StyleBuilder();
        Style rasterstyle = sb.createStyle();
        RasterSymbolizer raster = sb.createRasterSymbolizer();
        rasterstyle.featureTypeStyles().add(sb.createFeatureTypeStyle((Symbolizer)raster));
        ((FeatureTypeStyle)rasterstyle.featureTypeStyles().get(0)).setName("GridCoverage");
        return rasterstyle;
    }
}

