/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import com.sun.media.jai.widget.DisplayJAI;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Random;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.renderer.lite.gridcoverage2d.RasterSymbolizerHelper;
import org.geotools.renderer.lite.gridcoverage2d.SubchainStyleVisitorCoverageProcessingAdapter;
import org.geotools.resources.image.ComponentColorModelJAI;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.geotools.test.TestData;
import org.junit.Test;
import org.opengis.geometry.Envelope;
import org.opengis.style.ChannelSelection;
import org.opengis.style.ColorMap;
import org.opengis.style.ContrastEnhancement;
import org.opengis.style.ContrastMethod;

public class RasterSymbolizerTest {
    private static final StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());

    public static RenderedImage getSynthetic(double noDataValue) {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)500, (int)500, (int)1, null);
        Random random = new Random();
        int y = 0;
        while (y < 500) {
            int x = 0;
            while (x < 500) {
                if ((double)random.nextFloat() > 0.9) {
                    raster.setSample(x, y, 0, noDataValue);
                } else {
                    raster.setSample(x, y, 0, x + y);
                }
                ++x;
            }
            ++y;
        }
        ComponentColorModelJAI cm = new ComponentColorModelJAI(ColorSpace.getInstance(1003), false, false, 1, 5);
        BufferedImage image = new BufferedImage((ColorModel)cm, raster, false, null);
        return image;
    }

    @Test
    public void contrastEnhancementMethods() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"hs.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        URL surl = TestData.url((Object)this, (String)"histogram.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh_SLD = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh_SLD.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_SLD);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"hs.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        RasterSymbolizerHelper rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeGray.setChannelName("1");
        chTypeGray.setContrastEnhancement((ContrastEnhancement)cntEnh);
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh_StyleBuilder.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"hs.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        surl = TestData.url((Object)this, (String)"logarithmic.sld");
        stylereader = new SLDParser(sf, surl);
        sld = stylereader.parseSLD();
        rsh_SLD = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_2 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh_SLD.visit(rs_2);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_SLD);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"hs.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_2 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_2 = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_2 = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_2 = new ContrastEnhancementImpl();
        cntEnh_2.setLogarithmic();
        chTypeGray_2.setChannelName("1");
        chTypeGray_2.setContrastEnhancement((ContrastEnhancement)cntEnh_2);
        chSel_2.setGrayChannel((SelectedChannelType)chTypeGray_2);
        rsb_2.setChannelSelection((ChannelSelection)chSel_2);
        rsb_2.setOpacity(sldBuilder.literalExpression(1.0));
        rsh_StyleBuilder.visit(rsb_2);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"hs.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        surl = TestData.url((Object)this, (String)"exponential.sld");
        stylereader = new SLDParser(sf, surl);
        sld = stylereader.parseSLD();
        rsh_SLD = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_3 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh_SLD.visit(rs_3);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_SLD);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"hs.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        sldBuilder = new StyleBuilder();
        rsh_StyleBuilder = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_3 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel_3 = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray_3 = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh_3 = new ContrastEnhancementImpl();
        cntEnh_3.setExponential();
        chTypeGray_3.setChannelName("1");
        chTypeGray_3.setContrastEnhancement((ContrastEnhancement)cntEnh_3);
        chSel_3.setGrayChannel((SelectedChannelType)chTypeGray_3);
        rsb_3.setChannelSelection((ChannelSelection)chSel_3);
        rsb_3.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_3.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh_StyleBuilder.visit(rsb_3);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh_StyleBuilder);
    }

    @Test
    public void bandFloat32_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_1band_Float32.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        URL surl = TestData.url((Object)this, (String)"1band_Float32_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_1band_Float32.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setLogarithmic();
        chTypeGray.setChannelName("1");
        chTypeGray.setContrastEnhancement((ContrastEnhancement)cntEnh);
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void test1BandFloat32_ColorMap_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_1band_Float32.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        URL surl = TestData.url((Object)this, (String)"1band_Float32_test2.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        UserLayer nl = (UserLayer)sld.getStyledLayers()[0];
        Style style = nl.getUserStyles()[0];
        FeatureTypeStyle fts = style.getFeatureTypeStyles()[0];
        Rule rule = fts.getRules()[0];
        RasterSymbolizer rs_1 = (RasterSymbolizer)rule.getSymbolizers()[0];
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_1band_Float32.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeGray.setChannelName("1");
        chTypeGray.setContrastEnhancement((ContrastEnhancement)cntEnh);
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        org.geotools.styling.ColorMap cm = sldBuilder.createColorMap(new String[]{"category", "category", "category"}, new double[]{0.1, 50.0, 200.0}, new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 40), new Color(0, 0, 255, 125)}, 1);
        rsb_1.setColorMap((ColorMap)cm);
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void bandsUInt16_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1")};
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"test.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), gsd, null, null);
        URL surl = TestData.url((Object)this, (String)"4bands_UInt16_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_4bands_UInt16.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeRed = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeBlue = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeGreen = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeRed.setChannelName("1");
        chTypeBlue.setChannelName("2");
        chTypeGreen.setChannelName("3");
        chSel.setRGBChannels((SelectedChannelType)chTypeRed, (SelectedChannelType)chTypeBlue, (SelectedChannelType)chTypeGreen);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setContrastEnhancement((ContrastEnhancement)cntEnh);
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    private static RasterSymbolizer extractRasterSymbolizer(StyledLayerDescriptor sld) {
        UserLayer nl = (UserLayer)sld.getStyledLayers()[0];
        Style style = nl.getUserStyles()[0];
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Rule rule = (Rule)fts.rules().get(0);
        RasterSymbolizer rs_1 = (RasterSymbolizer)rule.getSymbolizers()[0];
        return rs_1;
    }

    @Test
    public void bandsByte_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1"), new GridSampleDimension((CharSequence)"test1BandByte_SLD2"), new GridSampleDimension((CharSequence)"test1BandByte_SLD3")};
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_3bands_Byte.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), gsd, null, null);
        URL surl = TestData.url((Object)this, (String)"3bands_Byte_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_3bands_Byte.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeRed = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeBlue = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl chTypeGreen = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        cntEnh.setGammaValue(sldBuilder.literalExpression(0.5));
        chTypeRed.setChannelName("1");
        chTypeBlue.setChannelName("2");
        chTypeGreen.setChannelName("3");
        chSel.setRGBChannels((SelectedChannelType)chTypeRed, (SelectedChannelType)chTypeBlue, (SelectedChannelType)chTypeGreen);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setContrastEnhancement((ContrastEnhancement)cntEnh);
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void bandsByte_ColorMap_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1"), new GridSampleDimension((CharSequence)"test1BandByte_SLD2"), new GridSampleDimension((CharSequence)"test1BandByte_SLD3")};
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_3bands_Byte.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), gsd, null, null);
        URL surl = TestData.url((Object)this, (String)"3bands_Byte_test2.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_3bands_Byte.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeGray.setChannelName("1");
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        rsb_1.setContrastEnhancement((ContrastEnhancement)cntEnh);
        rsb_1.setOverlap(sldBuilder.literalExpression("AVERAGE"));
        org.geotools.styling.ColorMap cm = sldBuilder.createColorMap(new String[]{"category", "category", "category"}, new double[]{0.1, 50.0, 200.0}, new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 40), new Color(0, 0, 255, 125)}, 1);
        rsb_1.setColorMap((ColorMap)cm);
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void BandByte_SLD() throws IOException, TransformerException, FactoryRegistryException, IllegalArgumentException, URISyntaxException {
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_1band_Byte.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD")}, null, null);
        URL surl = TestData.url((Object)this, (String)"1band_Float32_test1.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_1band_Byte.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        rsh = new RasterSymbolizerHelper(gc, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        ContrastEnhancementImpl cntEnh = new ContrastEnhancementImpl();
        cntEnh.setMethod(ContrastMethod.HISTOGRAM);
        chTypeGray.setChannelName("1");
        chTypeGray.setContrastEnhancement((ContrastEnhancement)cntEnh);
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsh.visit(rsb_1);
        RenderedImage im = ((GridCoverage2D)rsh.getOutput()).getRenderedImage();
        Assert.assertTrue((im.getSampleModel().getDataType() == 0 ? 1 : 0) != 0);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)new File(TestData.url((Object)this, (String)"small_1band_Byte.tif").toURI())), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        surl = TestData.url((Object)this, (String)"1band_Float32_test2.sld");
        stylereader = new SLDParser(sf, surl);
        sld = stylereader.parseSLD();
        rsh = new RasterSymbolizerHelper(gc, null);
        rs_1 = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void colorMap() throws IOException, TransformerException {
        URL sldURL = TestData.url((Object)this, (String)"colormap.sld");
        SLDParser stylereader = new SLDParser(sf, sldURL);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)RasterSymbolizerTest.getSynthetic(Double.NaN)), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"sd", new Category[]{new Category((CharSequence)"", Color.BLACK, 0)}, null)}, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        IndexColorModel icm1 = (IndexColorModel)((GridCoverage2D)rsh.getOutput()).getRenderedImage().getColorModel();
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)RasterSymbolizerTest.getSynthetic(Double.NaN)), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"sd", new Category[]{new Category((CharSequence)"", Color.BLACK, 0)}, null)}, null, null);
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        rs = sldBuilder.createRasterSymbolizer();
        org.geotools.styling.ColorMap cm = sldBuilder.createColorMap(new String[]{"category0", "category1", "category2"}, new double[]{100.0, 500.0, 900.0}, new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 204), new Color(0, 0, 255, 51)}, 1);
        cm.setExtendedColors(true);
        rs.setColorMap((ColorMap)cm);
        rsh.visit(rs);
        IndexColorModel icm2 = (IndexColorModel)((GridCoverage2D)rsh.getOutput()).getRenderedImage().getColorModel();
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        Assert.assertTrue((boolean)icm1.equals(icm2));
    }

    @Test
    public void rgb() throws IOException, TransformerException {
        URL surl = TestData.url((Object)this, (String)"testrgb.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1"), new GridSampleDimension((CharSequence)"test1BandByte_SLD2"), new GridSampleDimension((CharSequence)"test1BandByte_SLD3")};
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)this, (String)"bahamas_hires.jpg")), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), gsd, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void testGapsColor() throws IOException {
        URL surl = TestData.url((Object)this, (String)"Topsoil-Organic-Carbon.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1")};
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)this, (String)"toc.tif")), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), gsd, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void dem() throws IOException, TransformerException {
        URL surl = TestData.url((Object)this, (String)"raster_dem.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)this, (String)"smalldem.tif")), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
        gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)this, (String)"smalldem.tif")), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}));
        StyleBuilder sldBuilder = new StyleBuilder();
        rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rsb_1 = sldBuilder.createRasterSymbolizer();
        ChannelSelectionImpl chSel = new ChannelSelectionImpl();
        SelectedChannelTypeImpl chTypeGray = new SelectedChannelTypeImpl();
        chTypeGray.setChannelName("1");
        chSel.setGrayChannel((SelectedChannelType)chTypeGray);
        rsb_1.setChannelSelection((ChannelSelection)chSel);
        rsb_1.setOpacity(sldBuilder.literalExpression(1.0));
        org.geotools.styling.ColorMap cm = sldBuilder.createColorMap(new String[]{"category", "category", "category"}, new double[]{0.1, 50.0, 200.0}, new Color[]{new Color(255, 0, 0, 255), new Color(0, 255, 0, 40), new Color(0, 0, 255, 125)}, 1);
        rsb_1.setColorMap((ColorMap)cm);
        rsh.visit(rsb_1);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    @Test
    public void landsat() throws IOException, TransformerException {
        URL surl = TestData.url((Object)this, (String)"landsat.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridSampleDimension[] gsd = new GridSampleDimension[]{new GridSampleDimension((CharSequence)"test1BandByte_SLD1"), new GridSampleDimension((CharSequence)"test1BandByte_SLD2"), new GridSampleDimension((CharSequence)"test1BandByte_SLD3"), new GridSampleDimension((CharSequence)"test1BandByte_SLD4"), new GridSampleDimension((CharSequence)"test1BandByte_SLD5"), new GridSampleDimension((CharSequence)"test1BandByte_SLD6"), new GridSampleDimension((CharSequence)"test1BandByte_SLD")};
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)this, (String)"landsat.tiff")), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), gsd, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RenderedImage ri = ((GridCoverage2D)rsh.getOutput()).getRenderedImage();
        Assert.assertTrue((boolean)(ri.getColorModel() instanceof ComponentColorModel));
        Assert.assertTrue((ri.getColorModel().getNumComponents() == 3 ? 1 : 0) != 0);
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }

    private static void testRasterSymbolizerHelper(SubchainStyleVisitorCoverageProcessingAdapter rsh) {
        if (TestData.isInteractiveTest()) {
            RasterSymbolizerTest.visualize(((GridCoverage2D)rsh.getOutput()).getRenderedImage(), rsh.getName().toString());
        } else {
            PlanarImage.wrapRenderedImage((RenderedImage)((GridCoverage2D)rsh.getOutput()).getRenderedImage()).getTiles();
            rsh.dispose(new Random().nextBoolean());
        }
    }

    public static void visualize(RenderedImage ri, String name) throws HeadlessException {
        final JFrame jf = new JFrame(name);
        jf.setDefaultCloseOperation(3);
        jf.getContentPane().add((Component)new DisplayJAI(ri));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jf.pack();
                jf.setVisible(true);
            }
        });
    }

    @Test
    public void twoColorsTest() throws IOException {
        URL surl = TestData.url((Object)this, (String)"raster_discretecolors.sld");
        SLDParser stylereader = new SLDParser(sf, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        GridCoverage2D gc = CoverageFactoryFinder.getGridCoverageFactory(null).create((CharSequence)"name", (RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)this, (String)"smalldem.tif")), (Envelope)new GeneralEnvelope(new double[]{-90.0, -180.0}, new double[]{90.0, 180.0}), new GridSampleDimension[]{new GridSampleDimension((CharSequence)"dem")}, null, null);
        RasterSymbolizerHelper rsh = new RasterSymbolizerHelper(gc, null);
        RasterSymbolizer rs = RasterSymbolizerTest.extractRasterSymbolizer(sld);
        rsh.visit(rs);
        RenderedImage ri = ((GridCoverage2D)rsh.getOutput()).getRenderedImage();
        Assert.assertTrue((boolean)(ri.getColorModel() instanceof IndexColorModel));
        IndexColorModel icm = (IndexColorModel)ri.getColorModel();
        int mapSize = icm.getMapSize();
        Assert.assertEquals((int)3, (int)mapSize);
        int[] rgb = new int[mapSize];
        rgb[0] = 0xFFFFFF & icm.getRGB(0);
        rgb[1] = 0xFFFFFF & icm.getRGB(1);
        rgb[2] = 0xFFFFFF & icm.getRGB(2);
        int found = 0;
        int i = 0;
        while (i < mapSize) {
            switch (rgb[i]) {
                case 0: 
                case 32768: 
                case 0x663333: {
                    ++found;
                    break;
                }
                default: {
                    throw new IllegalStateException("Found unexpected colors:" + rgb[i]);
                }
            }
            ++i;
        }
        RasterSymbolizerTest.testRasterSymbolizerHelper((SubchainStyleVisitorCoverageProcessingAdapter)rsh);
    }
}

