/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.geotools.map.event.MapAdapter;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapLayerListEvent;

class WaitingMapListener
extends MapAdapter {
    private static final int N = Type.values().length;
    CountDownLatch[] latches = new CountDownLatch[N];

    WaitingMapListener() {
    }

    void setExpected(Type type) {
        this.setExpected(type, 1);
    }

    void setExpected(Type type, int count) {
        this.latches[type.ordinal()] = new CountDownLatch(count);
    }

    boolean await(Type type, long timeoutMillis) {
        int index = type.ordinal();
        if (this.latches[index] == null) {
            throw new IllegalStateException("Event type not expected: " + (Object)((Object)type));
        }
        boolean result = false;
        try {
            result = this.latches[index].await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public void layerAdded(MapLayerListEvent event) {
        this.catchEvent(Type.ADDED);
    }

    public void layerRemoved(MapLayerListEvent event) {
        this.catchEvent(Type.REMOVED);
    }

    public void layerChanged(MapLayerListEvent event) {
        this.catchEvent(Type.CHANGED);
    }

    public void layerMoved(MapLayerListEvent event) {
        this.catchEvent(Type.MOVED);
    }

    public void layerPreDispose(MapLayerListEvent event) {
        this.catchEvent(Type.PRE_DISPOSE);
    }

    public void mapBoundsChanged(MapBoundsEvent event) {
        this.catchEvent(Type.BOUNDS_CHANGED);
    }

    private void catchEvent(Type type) {
        int index = type.ordinal();
        if (this.latches[index] == null) {
            throw new IllegalStateException("Event type not expected: " + (Object)((Object)type));
        }
        this.latches[index].countDown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        ADDED,
        REMOVED,
        CHANGED,
        MOVED,
        PRE_DISPOSE,
        BOUNDS_CHANGED;

    }
}

