/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.io.WKTReader;
import java.util.List;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ProjectionHandlerTest {
    static final double EPS = 1.0E-6;
    static CoordinateReferenceSystem WGS84;
    static CoordinateReferenceSystem UTM32N;
    static CoordinateReferenceSystem MERCATOR;
    static CoordinateReferenceSystem MERCATOR_SHIFTED;

    @BeforeClass
    public static void setup() throws Exception {
        WGS84 = DefaultGeographicCRS.WGS84;
        UTM32N = CRS.decode((String)"EPSG:32632", (boolean)true);
        MERCATOR_SHIFTED = CRS.decode((String)"EPSG:3349", (boolean)true);
        MERCATOR = CRS.decode((String)"EPSG:3395", (boolean)true);
    }

    @Test
    public void testQueryWrappingWGS84() throws Exception {
        ReferencedEnvelope wgs84Envelope = new ReferencedEnvelope(-190.0, 60.0, -90.0, 45.0, WGS84);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)wgs84Envelope, (boolean)true);
        Assert.assertNull((Object)handler.validArea);
        List envelopes = handler.getQueryEnvelopes((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertEquals((long)2L, (long)envelopes.size());
        ReferencedEnvelope expected = new ReferencedEnvelope(170.0, 180.0, -90.0, 45.0, WGS84);
        Assert.assertTrue((boolean)envelopes.remove(wgs84Envelope));
        Assert.assertEquals((Object)expected, envelopes.get(0));
    }

    @Test
    public void testValidAreaMercator() throws Exception {
        ReferencedEnvelope world = new ReferencedEnvelope(-180.0, 180.0, -89.9999, 89.9999, WGS84);
        ReferencedEnvelope mercatorEnvelope = world.transform(MERCATOR_SHIFTED, true);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mercatorEnvelope, (boolean)true);
        ReferencedEnvelope va = handler.validArea;
        Assert.assertNotNull((Object)va);
        Assert.assertEquals((Object)WGS84, (Object)va.getCoordinateReferenceSystem());
        Assert.assertTrue((va.getMinX() <= -180.0 ? 1 : 0) != 0);
        Assert.assertTrue((va.getMaxX() >= 180.0 ? 1 : 0) != 0);
        Assert.assertTrue((-90.0 < va.getMinY() ? 1 : 0) != 0);
        Assert.assertTrue((90.0 > va.getMaxY() ? 1 : 0) != 0);
    }

    @Test
    public void testQueryWrappingMercatorWorld() throws Exception {
        ReferencedEnvelope world = new ReferencedEnvelope(-200.0, 200.0, -89.0, 89.0, WGS84);
        ReferencedEnvelope mercatorEnvelope = world.transform(MERCATOR_SHIFTED, true);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mercatorEnvelope, (boolean)true);
        List envelopes = handler.getQueryEnvelopes((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertEquals((long)1L, (long)envelopes.size());
        ReferencedEnvelope env = (ReferencedEnvelope)envelopes.get(0);
        Assert.assertEquals((double)-180.0, (double)env.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)180.0, (double)env.getMaxX(), (double)1.0E-6);
        Assert.assertEquals((double)-89.0, (double)env.getMinY(), (double)0.1);
        Assert.assertEquals((double)89.0, (double)env.getMaxY(), (double)0.1);
    }

    @Test
    public void testQueryWrappingMercatorSeparate() throws Exception {
        ReferencedEnvelope world = new ReferencedEnvelope(160.0, 180.0, -40.0, 40.0, WGS84);
        ReferencedEnvelope mercatorEnvelope = world.transform(MERCATOR, true);
        mercatorEnvelope.translate(mercatorEnvelope.getWidth() / 2.0, 0.0);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mercatorEnvelope, (boolean)true);
        List envelopes = handler.getQueryEnvelopes((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertEquals((long)2L, (long)envelopes.size());
        ReferencedEnvelope reOrig = (ReferencedEnvelope)envelopes.get(0);
        Assert.assertEquals((double)170.0, (double)reOrig.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)190.0, (double)reOrig.getMaxX(), (double)1.0E-6);
        ReferencedEnvelope reAdded = (ReferencedEnvelope)envelopes.get(1);
        Assert.assertEquals((double)-180.0, (double)reAdded.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)-170.0, (double)reAdded.getMaxX(), (double)1.0E-6);
    }

    @Test
    public void testValidAreaUTM() throws Exception {
        ReferencedEnvelope wgs84Envelope = new ReferencedEnvelope(8.0, 10.0, 40.0, 45.0, WGS84);
        ReferencedEnvelope utmEnvelope = wgs84Envelope.transform(UTM32N, true);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)utmEnvelope, (boolean)true);
        ReferencedEnvelope va = handler.validArea;
        Assert.assertNotNull((Object)va);
        Assert.assertEquals((Object)WGS84, (Object)va.getCoordinateReferenceSystem());
        Assert.assertTrue((-81.0 < va.getMinX() && va.getMinX() <= 6.0 ? 1 : 0) != 0);
        Assert.assertTrue((12.0 <= va.getMaxX() && va.getMaxX() < 99.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)-90.0, (double)va.getMinY(), (double)1.0E-6);
        Assert.assertEquals((double)90.0, (double)va.getMaxY(), (double)1.0E-6);
    }

    @Test
    public void testQueryUTM() throws Exception {
        ReferencedEnvelope wgs84Envelope = new ReferencedEnvelope(8.0, 10.0, 40.0, 45.0, WGS84);
        ReferencedEnvelope utmEnvelope = wgs84Envelope.transform(UTM32N, true);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)utmEnvelope, (boolean)true);
        ReferencedEnvelope expected = utmEnvelope.transform(WGS84, true);
        List envelopes = handler.getQueryEnvelopes((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertEquals((long)1L, (long)envelopes.size());
        Assert.assertEquals((Object)expected, envelopes.get(0));
    }

    @Test
    public void testWrapGeometryMercator() throws Exception {
        ReferencedEnvelope world = new ReferencedEnvelope(160.0, 180.0, -40.0, 40.0, WGS84);
        ReferencedEnvelope mercatorEnvelope = world.transform(MERCATOR, true);
        mercatorEnvelope.translate(mercatorEnvelope.getWidth() / 2.0, 0.0);
        Geometry g = new WKTReader().read("LINESTRING(170 -40, 190 40)");
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mercatorEnvelope, (boolean)true);
        Assert.assertTrue((boolean)handler.requiresProcessing(WGS84, g));
        Geometry preProcessed = handler.preProcess(WGS84, g);
        Assert.assertEquals((Object)g, (Object)preProcessed);
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)WGS84, (CoordinateReferenceSystem)MERCATOR, (boolean)true);
        Geometry transformed = JTS.transform((Geometry)g, (MathTransform)mt);
        Geometry postProcessed = handler.postProcess(mt.inverse(), transformed);
        Envelope env = postProcessed.getEnvelopeInternal();
        Assert.assertEquals((double)mercatorEnvelope.getMinX(), (double)env.getMinX(), (double)1.0E-6);
        Assert.assertEquals((double)mercatorEnvelope.getMaxX(), (double)env.getMaxX(), (double)1.0E-6);
    }

    @Test
    public void testWrapGeometrySmall() throws Exception {
        CoordinateReferenceSystem FIJI = CRS.decode((String)"EPSG:3460");
        Geometry g = new WKTReader().read("POLYGON ((2139122 5880020, 2139122 5880030, 2139922 5880030, 2139122 5880020))");
        Geometry original = (Geometry)g.clone();
        ReferencedEnvelope world = new ReferencedEnvelope(178.0, 181.0, -1.0, 1.0, WGS84);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)world, (boolean)true);
        Assert.assertTrue((boolean)handler.requiresProcessing(WGS84, g));
        Geometry preProcessed = handler.preProcess(WGS84, g);
        Assert.assertTrue((boolean)original.equals(preProcessed));
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)FIJI, (CoordinateReferenceSystem)WGS84);
        Geometry transformed = JTS.transform((Geometry)g, (MathTransform)mt);
        Geometry postProcessed = handler.postProcess(mt.inverse(), transformed);
        Assert.assertTrue((boolean)transformed.equals(postProcessed));
    }

    @Test
    public void testWrapGeometryWGS84() throws Exception {
        ReferencedEnvelope world = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, WGS84);
        Geometry g = new WKTReader().read("POLYGON((-178 -90, -178 90, 178 90, 178 -90, -178 -90))");
        Geometry original = new WKTReader().read("POLYGON((-178 -90, -178 90, 178 90, 178 -90, -178 -90))");
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)world, (boolean)true);
        Assert.assertTrue((boolean)handler.requiresProcessing(WGS84, g));
        Geometry preProcessed = handler.preProcess(WGS84, g);
        Assert.assertTrue((boolean)original.equals(preProcessed));
        Geometry postProcessed = handler.postProcess(CRS.findMathTransform((CoordinateReferenceSystem)WGS84, (CoordinateReferenceSystem)WGS84), g);
        Assert.assertTrue((boolean)original.equals(postProcessed));
    }

    @Test
    public void testWrapJumpLast() throws Exception {
        ReferencedEnvelope world = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, WGS84);
        Geometry g = new WKTReader().read("POLYGON((-131 -73.5,0 -90,163 -60,174 -60,-131 -73.5))");
        Geometry original = new WKTReader().read("POLYGON((-131 -73.5,0 -90,163 -60,174 -60,-131 -73.5))");
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)world, (boolean)true);
        Assert.assertTrue((boolean)handler.requiresProcessing(WGS84, g));
        Geometry preProcessed = handler.preProcess(WGS84, g);
        Assert.assertTrue((boolean)original.equalsExact(preProcessed));
        Geometry postProcessed = handler.postProcess(CRS.findMathTransform((CoordinateReferenceSystem)WGS84, (CoordinateReferenceSystem)WGS84), g);
        Assert.assertTrue((boolean)original.equalsExact(postProcessed));
    }

    @Test
    public void testWrapGeometryWGS84Duplicate() throws Exception {
        ReferencedEnvelope world = new ReferencedEnvelope(-200.0, 200.0, -90.0, 90.0, WGS84);
        Geometry g = new WKTReader().read("POLYGON((-178 -90, -178 90, 178 90, 178 -90, -178 -90))");
        Geometry original = new WKTReader().read("POLYGON((-178 -90, -178 90, 178 90, 178 -90, -178 -90))");
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)world, (boolean)true);
        Assert.assertTrue((boolean)handler.requiresProcessing(WGS84, g));
        Geometry preProcessed = handler.preProcess(WGS84, g);
        Assert.assertTrue((boolean)original.equals(preProcessed));
        Geometry postProcessed = handler.postProcess(null, g);
        Envelope ppEnvelope = postProcessed.getEnvelopeInternal();
        Envelope expected = new Envelope(-538.0, 538.0, -90.0, 90.0);
        Assert.assertEquals((Object)expected, (Object)ppEnvelope);
    }

    @Test
    public void testDuplicateGeometryMercator() throws Exception {
        ReferencedEnvelope world = new ReferencedEnvelope(-180.0, 180.0, -50.0, 50.0, WGS84);
        ReferencedEnvelope mercatorEnvelope = world.transform(MERCATOR, true);
        Geometry g = new WKTReader().read("LINESTRING(170 -50, 190 50)");
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mercatorEnvelope, (boolean)true);
        Assert.assertTrue((boolean)handler.requiresProcessing(WGS84, g));
        Geometry preProcessed = handler.preProcess(WGS84, g);
        Assert.assertEquals((Object)g, (Object)preProcessed);
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)WGS84, (CoordinateReferenceSystem)MERCATOR, (boolean)true);
        Geometry transformed = JTS.transform((Geometry)g, (MathTransform)mt);
        Geometry postProcessed = handler.postProcess(mt, transformed);
        Assert.assertTrue((boolean)(postProcessed instanceof MultiLineString));
        MultiLineString mls = (MultiLineString)postProcessed;
        Assert.assertEquals((long)2L, (long)mls.getNumGeometries());
        double twentyDegWidth = mercatorEnvelope.getWidth() / 18.0;
        Assert.assertEquals((double)twentyDegWidth, (double)mls.getGeometryN(0).getEnvelopeInternal().getWidth(), (double)1.0E-6);
        Assert.assertEquals((double)twentyDegWidth, (double)mls.getGeometryN(1).getEnvelopeInternal().getWidth(), (double)1.0E-6);
    }

    public void testCutGeometryUTM() throws Exception {
        ReferencedEnvelope wgs84Envelope = new ReferencedEnvelope(8.0, 10.0, 40.0, 45.0, WGS84);
        ReferencedEnvelope utmEnvelope = wgs84Envelope.transform(UTM32N, true);
        Geometry g = new WKTReader().read("LINESTRING(-170 -40, 170, 40)");
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)utmEnvelope, (boolean)true);
        Assert.assertTrue((boolean)handler.requiresProcessing(UTM32N, g));
        Geometry preProcessed = handler.preProcess(WGS84, g);
        Assert.assertTrue((!preProcessed.equals(g) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)handler.validArea.contains(preProcessed.getEnvelopeInternal()));
    }
}

