/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Font;
import java.awt.RenderingHints;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TileTest {
    private static final long TIME = 4000L;
    SimpleFeatureSource polyfs;
    SimpleFeatureSource linefs;
    ReferencedEnvelope leftTileBounds;
    ReferencedEnvelope rightTileBounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"tilerect.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.polyfs = ds.getFeatureSource("tilerect");
        property = new File(TestData.getResource((Object)this, (String)"tilelines.properties").toURI());
        ds = new PropertyDataStore(property.getParentFile());
        this.linefs = ds.getFeatureSource("tilelines");
        this.leftTileBounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, this.polyfs.getBounds().getCoordinateReferenceSystem());
        this.rightTileBounds = new ReferencedEnvelope(10.0, 20.0, 0.0, 10.0, this.polyfs.getBounds().getCoordinateReferenceSystem());
        Font f = Font.createFont(0, TestData.getResource((Object)this, (String)"recreate.ttf").openStream());
        FontCache.getDefaultInstance().registerFont(f);
    }

    @Test
    public void testFillAlignment() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fillCross.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.polyfs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("FillAlignment", (GTRenderer)renderer, 4000L, this.leftTileBounds, this.rightTileBounds);
    }

    @Test
    public void testStrokeAlignment() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "dotsStars.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.linefs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("StrokeAlignment", (GTRenderer)renderer, 4000L, this.leftTileBounds, this.rightTileBounds);
    }
}

