/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ImageGraphicFactory;
import org.geotools.renderer.style.TTFMarkFactory;
import org.geotools.renderer.style.WellKnownMarkFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSymbolFactoryFinderTest
extends TestCase {
    public void testLookupMarkFactories() {
        List result = this.loadIterator(DynamicSymbolFactoryFinder.getMarkFactories());
        DynamicSymbolFactoryFinderTest.assertTrue((result.size() >= 2 ? 1 : 0) != 0);
        this.assertContainsClassInstance(result, WellKnownMarkFactory.class);
        this.assertContainsClassInstance(result, TTFMarkFactory.class);
    }

    public void testLookupExternalGraphicFactories() {
        List result = this.loadIterator(DynamicSymbolFactoryFinder.getExternalGraphicFactories());
        DynamicSymbolFactoryFinderTest.assertTrue((result.size() >= 1 ? 1 : 0) != 0);
        this.assertContainsClassInstance(result, ImageGraphicFactory.class);
    }

    public void assertContainsClassInstance(List list, Class clazz) {
        for (Object item : list) {
            if (item == null || !clazz.isAssignableFrom(item.getClass())) continue;
            return;
        }
        DynamicSymbolFactoryFinderTest.fail((String)("List does not contain any element of class " + clazz.getName()));
    }

    public <T> List<T> loadIterator(Iterator<T> iterator) {
        ArrayList<T> result = new ArrayList<T>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }
}

