/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map.event;

import java.util.EventObject;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapBoundsEvent
extends EventObject {
    public static final int AREA_OF_INTEREST_MASK = 1;
    public static final int COORDINATE_SYSTEM_MASK = 2;
    private static final int NEXT_FLAG = 4;
    private int type;
    private ReferencedEnvelope oldAreaOfInterest;
    private ReferencedEnvelope newAreaOfInterest;

    public MapBoundsEvent(MapContext source, int type, ReferencedEnvelope oldAreaOfInterest, ReferencedEnvelope newAreaOfInterest) {
        super(source);
        if (type >= 4) {
            throw new IllegalArgumentException("Type is not acceptable, maximum value is 3, passed value is " + type);
        }
        this.type = type;
        this.oldAreaOfInterest = oldAreaOfInterest;
        this.newAreaOfInterest = newAreaOfInterest;
    }

    public int getType() {
        return this.type;
    }

    public CoordinateReferenceSystem getOldCoordinateReferenceSystem() {
        return this.oldAreaOfInterest.getCoordinateReferenceSystem();
    }

    public CoordinateReferenceSystem getNewCoordinateReferenceSystem() {
        return this.newAreaOfInterest.getCoordinateReferenceSystem();
    }

    public ReferencedEnvelope getOldAreaOfInterest() {
        return this.oldAreaOfInterest;
    }

    public ReferencedEnvelope getNewAreaOfInterest() {
        return this.newAreaOfInterest;
    }
}

