/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class OnlineTestCase
extends TestCase {
    public static final String SKIP_ON_FAILURE_KEY = "skip.on.failure";
    public static final String SKIP_ON_FAILURE_DEFAULT = "true";
    protected Properties fixture;
    protected boolean skipOnFailure = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        File base = new File(System.getProperty("user.home") + File.separator + ".geotools");
        String fixtureId = this.getFixtureId();
        if (fixtureId == null) {
            this.fixture = null;
            return;
        }
        File fixtureFile = new File(base, fixtureId.replace('.', File.separatorChar).concat(".properties"));
        if (fixtureFile.exists()) {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(fixtureFile));
            try {
                this.fixture = new Properties();
                this.fixture.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
            this.skipOnFailure = Boolean.parseBoolean(this.fixture.getProperty(SKIP_ON_FAILURE_KEY, SKIP_ON_FAILURE_DEFAULT));
            try {
                this.connect();
            }
            catch (Exception e) {
                if (this.skipOnFailure) {
                    this.fixture = null;
                    e.printStackTrace();
                }
                throw e;
            }
        }
    }

    protected void tearDown() throws Exception {
        block3: {
            if (this.fixture != null) {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    if (this.skipOnFailure) break block3;
                    throw e;
                }
            }
        }
    }

    protected void connect() throws Exception {
    }

    protected void disconnect() throws Exception {
    }

    protected void runTest() throws Throwable {
        if (this.fixture != null) {
            super.runTest();
        }
    }

    protected abstract String getFixtureId();
}

