/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sfs;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.sfs.SFSDataStore;
import org.geotools.data.sfs.SFSDataStoreUtil;
import org.geotools.data.sfs.SFSLayer;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.store.ContentState;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

class SFSFeatureReader
implements SimpleFeatureReader {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.simplefeatureservice");
    ContentState contentState;
    FeatureJSON fjson;
    FeatureIterator<SimpleFeature> featureIterator;
    InputStream jsonStream;
    SFSLayer layer;
    SimpleFeatureBuilder fbuilder;
    Boolean hasNext;

    public SFSFeatureReader(ContentState contentState, SFSLayer layer, Query fnQuery, SimpleFeatureType targetSchema) throws IOException {
        this.contentState = contentState;
        this.layer = layer;
        SFSDataStore ods = (SFSDataStore)contentState.getEntry().getDataStore();
        String queryURL = null;
        if (fnQuery != null) {
            queryURL = SFSDataStoreUtil.encodeQuery(fnQuery, targetSchema);
        }
        this.jsonStream = ods.resourceToStream("data/" + layer.getTypeName().getLocalPart(), "mode=features&" + queryURL);
        this.fjson = new FeatureJSON();
        this.fjson.setFeatureType(contentState.getFeatureType());
        this.featureIterator = this.fjson.streamFeatureCollection((Object)this.jsonStream);
        this.fbuilder = new SimpleFeatureBuilder(targetSchema);
    }

    public SimpleFeatureType getFeatureType() {
        return this.contentState.getFeatureType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        try {
            SimpleFeature sf = (SimpleFeature)this.featureIterator.next();
            if (!this.layer.isXYOrder()) {
                ArrayList al;
                Geometry fg = (Geometry)sf.getDefaultGeometry();
                if (fg != null) {
                    SFSDataStoreUtil.flipFeatureYX(fg);
                }
                if ((al = (ArrayList)sf.getAttribute("boundedBy")) != null) {
                    SFSDataStoreUtil.flipYXInsideTheBoundingBox(al);
                }
            }
            for (AttributeDescriptor at : this.fbuilder.getFeatureType().getAttributeDescriptors()) {
                if (at instanceof GeometryDescriptor) {
                    this.fbuilder.add(sf.getDefaultGeometry());
                    continue;
                }
                this.fbuilder.add(sf.getAttribute(at.getLocalName()));
            }
            SimpleFeature simpleFeature = this.fbuilder.buildFeature(sf.getID());
            return simpleFeature;
        }
        finally {
            this.hasNext = null;
        }
    }

    public boolean hasNext() throws IOException {
        if (this.hasNext == null) {
            this.hasNext = this.featureIterator.hasNext();
        }
        return this.hasNext;
    }

    public void close() throws IOException {
        this.jsonStream.close();
        this.featureIterator.close();
    }

    public static void main(String[] args) throws Exception {
        String json = "{\"type\":\"FeatureCollection\",\"features\":[{\"type\":\"Feature\",\"geometry\":{\"type\":\"Point\",\"coordinates\":[43.3599,-11.6515]},\"properties\": {},\"id\":\"null\"}]}";
        FeatureJSON fj = new FeatureJSON();
        System.out.println(fj.readFeature((Object)json));
    }
}

