/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sfs;

import org.geotools.data.QueryCapabilities;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.sort.SortBy;

class SFSQueryCapabilities
extends QueryCapabilities {
    SimpleFeatureType schema;

    public SFSQueryCapabilities(SimpleFeatureType schema) {
        if (schema == null) {
            throw new NullPointerException("Provided schema is null");
        }
        this.schema = schema;
    }

    public boolean isOffsetSupported() {
        return true;
    }

    public boolean supportsSorting(SortBy[] sortAttributes) {
        if (sortAttributes == null || sortAttributes.length == 0) {
            return false;
        }
        for (SortBy sortBy : sortAttributes) {
            AttributeDescriptor att = this.schema.getDescriptor(sortBy.getPropertyName().getPropertyName());
            if (att != null && !(att instanceof GeometryDescriptor)) continue;
            return false;
        }
        return true;
    }
}

