/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import org.geotools.data.FIDReader;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.IndexedDbaseFileReader;
import org.geotools.data.shapefile.indexed.IndexedFidReader;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.renderer.shape.shapehandler.jts.MultiPointHandler;
import org.geotools.renderer.shape.shapehandler.jts.PointHandler;
import org.geotools.renderer.shape.shapehandler.simple.MultiLineHandler;
import org.geotools.renderer.shape.shapehandler.simple.PolygonHandler;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ShapefileRendererUtil {
    private static final FileReader FILE_READER = new FileReader(){

        public String id() {
            return ShapefileRendererUtil.class.getName() + "$" + this.getClass().getName();
        }
    };

    public static ShapefileReader getShpReader(ShapefileDataStore ds, Envelope bbox, Rectangle screenSize, MathTransform mt, boolean hasOpacity, boolean returnJTS) throws IOException, TransformException {
        ShapefileReader reader = ds.openShapeReader(new GeometryFactory());
        ShapeType type = reader.getHeader().getShapeType();
        if (type == ShapeType.ARC || type == ShapeType.ARCM || type == ShapeType.ARCZ) {
            if (returnJTS) {
                reader.setHandler((ShapeHandler)new org.geotools.renderer.shape.shapehandler.jts.MultiLineHandler(type, bbox, mt, hasOpacity, screenSize));
            } else {
                reader.setHandler((ShapeHandler)new MultiLineHandler(type, bbox, mt, hasOpacity, screenSize));
            }
        }
        if (type == ShapeType.POLYGON || type == ShapeType.POLYGONM || type == ShapeType.POLYGONZ) {
            if (returnJTS) {
                reader.setHandler((ShapeHandler)new org.geotools.renderer.shape.shapehandler.jts.PolygonHandler(type, bbox, mt, hasOpacity));
            } else {
                reader.setHandler((ShapeHandler)new PolygonHandler(type, bbox, mt, hasOpacity));
            }
        }
        if (type == ShapeType.POINT || type == ShapeType.POINTM || type == ShapeType.POINTZ) {
            if (returnJTS) {
                reader.setHandler((ShapeHandler)new PointHandler(type, bbox, screenSize, mt, hasOpacity));
            } else {
                reader.setHandler((ShapeHandler)new org.geotools.renderer.shape.shapehandler.simple.PointHandler(type, bbox, screenSize, mt, hasOpacity));
            }
        }
        if (type == ShapeType.MULTIPOINT || type == ShapeType.MULTIPOINTM || type == ShapeType.MULTIPOINTZ) {
            if (returnJTS) {
                reader.setHandler((ShapeHandler)new MultiPointHandler(type, bbox, screenSize, mt, hasOpacity));
            } else {
                reader.setHandler((ShapeHandler)new org.geotools.renderer.shape.shapehandler.simple.MultiPointHandler(type, bbox, screenSize, mt, hasOpacity));
            }
        }
        return reader;
    }

    public static IndexedDbaseFileReader getDBFReader(ShapefileDataStore ds) throws IOException {
        return new IndexedDbaseFileReader(ds.shpFiles, ds.useMemoryMappedBuffer, ds.getStringCharset());
    }

    public static ReadableByteChannel getShpReadChannel(ShapefileDataStore ds) throws IOException {
        return ds.shpFiles.getReadChannel(ShpFileType.SHP, FILE_READER);
    }

    public static URL getshpURL(ShapefileDataStore ds) {
        return ds.shpFiles.acquireRead(ShpFileType.SHP, FILE_READER);
    }

    public static FIDReader getFidReader(ShapefileDataStore datastore, RecordNumberTracker tracker) throws MalformedURLException {
        if (datastore instanceof IndexedShapefileDataStore) {
            IndexedShapefileDataStore ids = (IndexedShapefileDataStore)datastore;
            if (!ids.indexUseable(ShpFileType.FIX)) {
                return ShapefileRendererUtil.createBasicFidReader(datastore, tracker);
            }
            try {
                return new IndexedFidReader(ids.shpFiles);
            }
            catch (Exception e) {
                return ShapefileRendererUtil.createBasicFidReader(datastore, tracker);
            }
        }
        return ShapefileRendererUtil.createBasicFidReader(datastore, tracker);
    }

    private static FIDReader createBasicFidReader(ShapefileDataStore datastore, final RecordNumberTracker tracker) {
        final String typename = datastore.getCurrentTypeName() + ".";
        return new FIDReader(){
            int i = 0;
            boolean closed = false;

            public void close() throws IOException {
                this.closed = true;
            }

            public boolean hasNext() throws IOException {
                return !this.closed;
            }

            public String next() throws IOException {
                if (this.closed) {
                    throw new IllegalStateException("Reader is closed");
                }
                ++this.i;
                return typename + tracker.getRecordNumber();
            }
        };
    }

    public static ShpFiles getShpFiles(ShapefileDataStore ds) {
        return ds.shpFiles;
    }
}

