/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.swing.MapLayerTable;
import org.geotools.swing.RenderingExecutor;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.event.MapPaneListener;
import org.geotools.swing.tool.CursorTool;
import org.geotools.swing.tool.MapToolManager;
import org.opengis.geometry.Envelope;

public class JMapPane
extends JPanel
implements MapLayerListListener,
MapBoundsListener {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    public static final int DEFAULT_RESIZING_PAINT_DELAY = 500;
    private ScheduledExecutorService paneTaskExecutor = Executors.newSingleThreadScheduledExecutor();
    private Future<?> resizedFuture;
    private Future<?> imageMovedFuture;
    private int resizingPaintDelay = 500;
    private boolean acceptRepaintRequests = true;
    private ReferencedEnvelope pendingDisplayArea;
    private ReferencedEnvelope currentDisplayArea;
    private ReferencedEnvelope fullExtent;
    private DragBox dragBox;
    private MapContext context;
    private GTRenderer renderer;
    private LabelCache labelCache;
    private RenderingExecutor renderingExecutor;
    private MapToolManager toolManager;
    private MapLayerTable layerTable;
    private Set<MapPaneListener> listeners = new HashSet<MapPaneListener>();
    private AffineTransform worldToScreen;
    private AffineTransform screenToWorld;
    private Rectangle currentPaintArea;
    private BufferedImage baseImage;
    private Graphics2D baseImageGraphics;
    private Point imageOrigin = new Point(0, 0);
    private AtomicBoolean baseImageMoved = new AtomicBoolean();
    private AtomicBoolean clearLabelCache = new AtomicBoolean();

    public JMapPane() {
        this(null, null);
    }

    public JMapPane(GTRenderer renderer, MapContext context) {
        this.doSetRenderer(renderer);
        this.doSetMapContext(context);
        this.renderingExecutor = new RenderingExecutor(this);
        this.toolManager = new MapToolManager(this);
        this.dragBox = new DragBox();
        this.addMouseListener(this.dragBox);
        this.addMouseMotionListener(this.dragBox);
        this.addMouseListener(this.toolManager);
        this.addMouseMotionListener(this.toolManager);
        this.addMouseWheelListener(this.toolManager);
        this.addMouseListener(new MouseInputAdapter(){

            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                CursorTool tool = JMapPane.this.toolManager.getCursorTool();
                if (tool != null) {
                    JMapPane.this.setCursor(tool.getCursor());
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent he) {
                if ((he.getChangeFlags() & 4L) != 0L && JMapPane.this.isShowing() && JMapPane.this.baseImage == null) {
                    JMapPane.this.onShownOrResized();
                }
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent he) {
                if (JMapPane.this.isShowing()) {
                    JMapPane.this.onShownOrResized();
                }
            }
        });
    }

    private void onShownOrResized() {
        if (this.resizedFuture != null && !this.resizedFuture.isDone()) {
            this.resizedFuture.cancel(true);
        }
        this.resizedFuture = this.paneTaskExecutor.schedule(new Runnable(){

            public void run() {
                JMapPane.this.setForNewSize();
            }
        }, (long)this.resizingPaintDelay, TimeUnit.MILLISECONDS);
    }

    private void setForNewSize() {
        this.currentPaintArea = this.getVisibleRect();
        --this.currentPaintArea.width;
        --this.currentPaintArea.height;
        if (this.context != null && this.context.getLayerCount() > 0) {
            if (this.fullExtent == null) {
                this.setFullExtent();
            }
            if (this.pendingDisplayArea != null) {
                this.doSetDisplayArea((Envelope)this.pendingDisplayArea);
                this.pendingDisplayArea = null;
            } else {
                this.doSetDisplayArea((Envelope)this.fullExtent);
            }
            this.acceptRepaintRequests = true;
            this.drawBaseImage(true);
            MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.PANE_RESIZED);
            this.publishEvent(ev);
        }
    }

    public void setCursorTool(CursorTool tool) {
        if (tool == null) {
            this.toolManager.setNoCursorTool();
            this.setCursor(Cursor.getDefaultCursor());
            this.dragBox.setEnabled(false);
        } else {
            this.setCursor(tool.getCursor());
            this.toolManager.setCursorTool(tool);
            this.dragBox.setEnabled(tool.drawDragBox());
        }
    }

    public void addMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        this.toolManager.addMouseListener(listener);
    }

    public void removeMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        this.toolManager.removeMouseListener(listener);
    }

    public void addMapPaneListener(MapPaneListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        this.listeners.add(listener);
    }

    public void setMapLayerTable(MapLayerTable layerTable) {
        if (layerTable == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        this.layerTable = layerTable;
    }

    public GTRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(GTRenderer renderer) {
        this.doSetRenderer(renderer);
    }

    private void doSetRenderer(GTRenderer renderer) {
        if (renderer != null && renderer instanceof StreamingRenderer) {
            HashMap<String, LabelCache> hints = renderer.getRendererHints();
            if (hints == null) {
                hints = new HashMap<String, LabelCache>();
            }
            if (hints.containsKey("labelCache")) {
                this.labelCache = (LabelCache)hints.get("labelCache");
            } else {
                this.labelCache = new LabelCacheImpl();
                hints.put("labelCache", this.labelCache);
            }
            renderer.setRendererHints(hints);
            if (this.context != null) {
                renderer.setContext(this.context);
            }
        }
        this.renderer = renderer;
    }

    public MapContext getMapContext() {
        return this.context;
    }

    public void setMapContext(MapContext context) {
        this.doSetMapContext(context);
    }

    private void doSetMapContext(MapContext context) {
        if (this.context != context) {
            MapLayer layer;
            int n;
            int n2;
            MapLayer[] mapLayerArray;
            if (this.context != null) {
                this.context.removeMapLayerListListener((MapLayerListListener)this);
                mapLayerArray = this.context.getLayers();
                n2 = mapLayerArray.length;
                n = 0;
                while (n < n2) {
                    layer = mapLayerArray[n];
                    if (layer instanceof ComponentListener) {
                        this.removeComponentListener((ComponentListener)layer);
                    }
                    ++n;
                }
            }
            this.context = context;
            if (context != null) {
                this.context.addMapLayerListListener((MapLayerListListener)this);
                this.context.addMapBoundsListener((MapBoundsListener)this);
                mapLayerArray = context.getLayers();
                n2 = mapLayerArray.length;
                n = 0;
                while (n < n2) {
                    layer = mapLayerArray[n];
                    layer.setSelected(true);
                    if (layer instanceof ComponentListener) {
                        this.addComponentListener((ComponentListener)layer);
                    }
                    ++n;
                }
                this.setFullExtent();
            }
            if (this.renderer != null) {
                this.renderer.setContext(this.context);
            }
            MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.NEW_CONTEXT);
            this.publishEvent(ev);
        }
    }

    public ReferencedEnvelope getDisplayArea() {
        return new ReferencedEnvelope(this.currentDisplayArea);
    }

    private void calculateDisplayArea() {
        if (this.currentPaintArea != null && this.screenToWorld != null) {
            Point2D.Double p0 = new Point2D.Double(this.currentPaintArea.getMinX(), this.currentPaintArea.getMinY());
            Point2D.Double p1 = new Point2D.Double(this.currentPaintArea.getMaxX(), this.currentPaintArea.getMaxY());
            this.screenToWorld.transform(p0, p0);
            this.screenToWorld.transform(p1, p1);
            this.currentDisplayArea = new ReferencedEnvelope(Math.min(((Point2D)p0).getX(), ((Point2D)p1).getX()), Math.max(((Point2D)p0).getX(), ((Point2D)p1).getX()), Math.min(((Point2D)p0).getY(), ((Point2D)p1).getY()), Math.max(((Point2D)p0).getY(), ((Point2D)p1).getY()), this.context.getCoordinateReferenceSystem());
        }
    }

    public void setDisplayArea(Envelope envelope) {
        if (this.context != null) {
            if (this.currentPaintArea == null || this.currentPaintArea.isEmpty()) {
                this.pendingDisplayArea = new ReferencedEnvelope(envelope);
            } else {
                this.doSetDisplayArea(envelope);
                this.clearLabelCache.set(true);
                this.drawBaseImage(false);
            }
        } else {
            throw new IllegalStateException("Map context must be set before setting the display area");
        }
    }

    private void doSetDisplayArea(Envelope envelope) {
        assert (this.context != null && this.currentPaintArea != null && !this.currentPaintArea.isEmpty());
        if (this.equalsFullExtent(envelope)) {
            this.setTransforms((Envelope)this.fullExtent, this.currentPaintArea);
        } else {
            this.setTransforms(envelope, this.currentPaintArea);
        }
        this.calculateDisplayArea();
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.DISPLAY_AREA_CHANGED);
        this.publishEvent(ev);
    }

    private boolean equalsFullExtent(Envelope envelope) {
        if (this.fullExtent == null || envelope == null) {
            return false;
        }
        double TOL = 1.0E-6 * (this.fullExtent.getWidth() + this.fullExtent.getHeight());
        boolean touch = false;
        if (Math.abs(envelope.getMinimum(0) - this.fullExtent.getMinimum(0)) < TOL) {
            touch = true;
        }
        if (Math.abs(envelope.getMaximum(0) - this.fullExtent.getMaximum(0)) < TOL && touch) {
            return true;
        }
        if (Math.abs(envelope.getMinimum(1) - this.fullExtent.getMinimum(1)) < TOL) {
            touch = true;
        }
        return Math.abs(envelope.getMaximum(1) - this.fullExtent.getMaximum(1)) < TOL && touch;
    }

    public void reset() {
        if (this.fullExtent != null) {
            this.setDisplayArea((Envelope)this.fullExtent);
        }
    }

    public void setRepaint(boolean repaint) {
        this.acceptRepaintRequests = repaint;
        this.setIgnoreRepaint(!repaint);
    }

    public boolean isAcceptingRepaints() {
        return this.acceptRepaintRequests;
    }

    public RenderedImage getBaseImage() {
        return this.baseImage;
    }

    public int getResizeDelay() {
        return this.resizingPaintDelay;
    }

    public void setResizeDelay(int delay) {
        this.resizingPaintDelay = delay < 0 ? 500 : delay;
    }

    public AffineTransform getScreenToWorldTransform() {
        if (this.screenToWorld != null) {
            return new AffineTransform(this.screenToWorld);
        }
        return null;
    }

    public AffineTransform getWorldToScreenTransform() {
        if (this.worldToScreen != null) {
            return new AffineTransform(this.worldToScreen);
        }
        return null;
    }

    public void moveImage(int dx, int dy) {
        this.imageOrigin.translate(dx, dy);
        this.baseImageMoved.set(true);
        this.repaint();
        this.onImageMoved();
    }

    private void onImageMoved() {
        if (this.imageMovedFuture != null && !this.imageMovedFuture.isDone()) {
            this.imageMovedFuture.cancel(true);
        }
        this.imageMovedFuture = this.paneTaskExecutor.schedule(new Runnable(){

            public void run() {
                JMapPane.this.afterImageMoved();
                JMapPane.this.clearLabelCache.set(true);
                JMapPane.this.drawBaseImage(false);
                JMapPane.this.repaint();
            }
        }, (long)this.resizingPaintDelay, TimeUnit.MILLISECONDS);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.baseImage != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage((Image)this.baseImage, this.imageOrigin.x, this.imageOrigin.y, null);
            return;
        }
    }

    private void drawBaseImage(boolean createNewImage) {
        if (this.currentPaintArea == null) {
            return;
        }
        if (this.acceptRepaintRequests) {
            if (createNewImage) {
                this.baseImage = new BufferedImage(this.currentPaintArea.width + 1, this.currentPaintArea.height + 1, 2);
                if (this.baseImageGraphics != null) {
                    this.baseImageGraphics.dispose();
                }
                this.baseImageGraphics = this.baseImage.createGraphics();
                this.clearLabelCache.set(true);
            }
            if (this.renderingExecutor.submit(this.currentDisplayArea, this.currentPaintArea, this.baseImageGraphics)) {
                MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STARTED);
                this.publishEvent(ev);
            } else {
                this.onRenderingRejected();
            }
        }
    }

    public void onRenderingCompleted() {
        if (this.clearLabelCache.get()) {
            this.labelCache.clear();
        }
        this.clearLabelCache.set(false);
        this.repaint();
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED);
        this.publishEvent(ev);
    }

    public void onRenderingCancelled() {
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED);
        this.publishEvent(ev);
    }

    public void onRenderingFailed() {
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.RENDERING_STOPPED);
        this.publishEvent(ev);
    }

    public void onRenderingRejected() {
    }

    protected void afterImageMoved() {
        int dx = this.imageOrigin.x;
        int dy = this.imageOrigin.y;
        DirectPosition2D newPos = new DirectPosition2D((double)dx, (double)dy);
        this.screenToWorld.transform((Point2D)newPos, (Point2D)newPos);
        ReferencedEnvelope env = new ReferencedEnvelope(this.currentDisplayArea);
        env.translate(env.getMinimum(0) - newPos.x, env.getMaximum(1) - newPos.y);
        this.doSetDisplayArea((Envelope)env);
        this.imageOrigin.setLocation(0, 0);
        this.baseImageMoved.set(false);
    }

    public void layerAdded(MapLayerListEvent event) {
        if (this.layerTable != null) {
            this.layerTable.onAddLayer(event.getLayer());
        }
        MapLayer layer = event.getLayer();
        layer.setSelected(true);
        if (layer instanceof ComponentListener) {
            this.addComponentListener((ComponentListener)layer);
        }
        boolean atFullExtent = this.equalsFullExtent((Envelope)this.getDisplayArea());
        this.setFullExtent();
        if (this.context.getLayerCount() == 1 || atFullExtent) {
            this.reset();
        }
        this.drawBaseImage(false);
        this.repaint();
    }

    public void layerRemoved(MapLayerListEvent event) {
        MapLayer layer = event.getLayer();
        if (this.layerTable != null) {
            this.layerTable.onRemoveLayer(layer);
        }
        if (layer instanceof ComponentListener) {
            this.addComponentListener((ComponentListener)layer);
        }
        if (this.context.getLayerCount() == 0) {
            this.clearFields();
        } else {
            this.setFullExtent();
        }
        this.drawBaseImage(false);
        this.repaint();
    }

    public void layerChanged(MapLayerListEvent event) {
        int reason;
        if (this.layerTable != null) {
            this.layerTable.repaint(event.getLayer());
        }
        if ((reason = event.getMapLayerEvent().getReason()) == 3) {
            this.setFullExtent();
        }
        if (reason != 6) {
            this.drawBaseImage(false);
        }
        this.repaint();
    }

    public void layerMoved(MapLayerListEvent event) {
        this.drawBaseImage(false);
        this.repaint();
    }

    public void mapBoundsChanged(MapBoundsEvent event) {
        int type = event.getType();
        if ((type & 2) != 0) {
            this.setFullExtent();
            this.reset();
        }
    }

    private void setFullExtent() {
        if (this.context != null && this.context.getLayerCount() > 0) {
            try {
                this.fullExtent = this.context.getLayerBounds();
                if (this.fullExtent == null) {
                    this.fullExtent = new ReferencedEnvelope(-1.0, 1.0, -1.0, 1.0, this.context.getCoordinateReferenceSystem());
                }
                double w = this.fullExtent.getWidth();
                double h = this.fullExtent.getHeight();
                double x = this.fullExtent.getMinimum(0);
                double y = this.fullExtent.getMinimum(1);
                double xmin = x;
                double xmax = x + w;
                if (w <= 0.0) {
                    xmin = x - 1.0;
                    xmax = x + 1.0;
                }
                double ymin = y;
                double ymax = y + h;
                if (h <= 0.0) {
                    ymin = y - 1.0;
                    ymax = y + 1.0;
                }
                this.fullExtent = new ReferencedEnvelope(xmin, xmax, ymin, ymax, this.context.getCoordinateReferenceSystem());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            this.fullExtent = null;
        }
    }

    private void setTransforms(Envelope envelope, Rectangle paintArea) {
        ReferencedEnvelope refEnv = new ReferencedEnvelope(envelope);
        double xscale = paintArea.getWidth() / refEnv.getWidth();
        double yscale = paintArea.getHeight() / refEnv.getHeight();
        double scale = Math.min(xscale, yscale);
        double xoff = refEnv.getMedian(0) * scale - paintArea.getCenterX();
        double yoff = refEnv.getMedian(1) * scale + paintArea.getCenterY();
        this.worldToScreen = new AffineTransform(scale, 0.0, 0.0, -scale, -xoff, yoff);
        try {
            this.screenToWorld = this.worldToScreen.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            throw new RuntimeException("Unable to create coordinate transforms.", ex);
        }
    }

    private void publishEvent(MapPaneEvent ev) {
        for (MapPaneListener listener : this.listeners) {
            switch (ev.getType()) {
                case NEW_CONTEXT: {
                    listener.onNewContext(ev);
                    break;
                }
                case NEW_RENDERER: {
                    listener.onNewRenderer(ev);
                    break;
                }
                case PANE_RESIZED: {
                    listener.onResized(ev);
                    break;
                }
                case DISPLAY_AREA_CHANGED: {
                    listener.onDisplayAreaChanged(ev);
                    break;
                }
                case RENDERING_STARTED: {
                    listener.onRenderingStarted(ev);
                    break;
                }
                case RENDERING_STOPPED: {
                    listener.onRenderingStopped(ev);
                    break;
                }
                case RENDERING_PROGRESS: {
                    listener.onRenderingProgress(ev);
                }
            }
        }
    }

    private void clearFields() {
        this.fullExtent = null;
        this.worldToScreen = null;
        this.screenToWorld = null;
    }

    private class DragBox
    extends MouseInputAdapter {
        private Point startPos;
        private Rectangle rect = new Rectangle();
        private boolean dragged = false;
        private boolean enabled = false;

        DragBox() {
        }

        void setEnabled(boolean state) {
            this.enabled = state;
        }

        public void mousePressed(MouseEvent e) {
            this.startPos = new Point(e.getPoint());
        }

        public void mouseDragged(MouseEvent e) {
            if (this.enabled) {
                Graphics2D g2D = (Graphics2D)JMapPane.this.getGraphics();
                g2D.setColor(Color.WHITE);
                g2D.setXORMode(Color.RED);
                if (this.dragged) {
                    g2D.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                }
                this.rect.setFrameFromDiagonal(this.startPos, e.getPoint());
                g2D.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                this.dragged = true;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragged) {
                Graphics2D g2D = (Graphics2D)JMapPane.this.getGraphics();
                g2D.setColor(Color.WHITE);
                g2D.setXORMode(Color.RED);
                g2D.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                this.dragged = false;
            }
        }
    }
}

