/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.swing.JMapPane;
import org.opengis.feature.simple.SimpleFeature;

public class RenderingExecutor {
    private final JMapPane mapPane;
    private final ExecutorService taskExecutor;
    private final ScheduledExecutorService watchExecutor;
    public static final long DEFAULT_POLLING_INTERVAL = 20L;
    private long pollingInterval;
    private CountDownLatch cancelLatch;
    private long numFeatures;
    private AtomicBoolean taskRunning = new AtomicBoolean(false);
    private Task task;
    private Future<TaskResult> taskResult;
    private ScheduledFuture<?> watcher;

    public RenderingExecutor(JMapPane mapPane) {
        this.mapPane = mapPane;
        this.taskExecutor = Executors.newSingleThreadExecutor();
        this.watchExecutor = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
        this.pollingInterval = 20L;
        this.cancelLatch = new CountDownLatch(0);
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long interval) {
        if (interval > 0L) {
            this.pollingInterval = interval;
        }
    }

    public synchronized boolean submit(ReferencedEnvelope envelope, Rectangle paintArea, Graphics2D graphics) {
        if (!this.isRunning() || this.cancelLatch.getCount() > 0L) {
            try {
                this.cancelLatch.await();
            }
            catch (InterruptedException ex) {
                return false;
            }
            this.task = new Task(envelope, paintArea, graphics);
            this.taskRunning.set(true);
            this.taskResult = this.taskExecutor.submit(this.task);
            this.watcher = this.watchExecutor.scheduleAtFixedRate(new Runnable(){

                public void run() {
                    RenderingExecutor.this.pollTaskResult();
                }
            }, 20L, 20L, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    public synchronized void cancelTask() {
        if (this.isRunning()) {
            this.task.cancel();
            this.cancelLatch = new CountDownLatch(1);
        }
    }

    private void pollTaskResult() {
        if (!this.taskResult.isDone()) {
            return;
        }
        TaskResult result = TaskResult.PENDING;
        try {
            result = this.taskResult.get();
        }
        catch (Exception ex) {
            throw new IllegalStateException("When getting rendering result", ex);
        }
        this.watcher.cancel(false);
        this.taskRunning.set(false);
        this.cancelLatch.countDown();
        switch (result) {
            case CANCELLED: {
                this.mapPane.onRenderingCancelled();
                break;
            }
            case COMPLETED: {
                this.mapPane.onRenderingCompleted();
                break;
            }
            case FAILED: {
                this.mapPane.onRenderingFailed();
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.taskRunning.get();
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Task
    implements Callable<TaskResult>,
    RenderListener {
        private final ReferencedEnvelope envelope;
        private final Rectangle paintArea;
        private final Graphics2D graphics;
        private boolean cancelled;
        private boolean failed;

        public Task(ReferencedEnvelope envelope, Rectangle paintArea, Graphics2D graphics) {
            this.envelope = envelope;
            this.paintArea = paintArea;
            this.graphics = graphics;
            this.cancelled = false;
            this.failed = false;
        }

        @Override
        public TaskResult call() throws Exception {
            if (!this.cancelled) {
                GTRenderer renderer = RenderingExecutor.this.mapPane.getRenderer();
                try {
                    renderer.addRenderListener((RenderListener)this);
                    Composite composite = this.graphics.getComposite();
                    this.graphics.setComposite(AlphaComposite.getInstance(1, 0.0f));
                    this.graphics.fill(this.paintArea);
                    this.graphics.setComposite(composite);
                    RenderingExecutor.this.numFeatures = 0L;
                    renderer.paint(this.graphics, RenderingExecutor.this.mapPane.getVisibleRect(), this.envelope, RenderingExecutor.this.mapPane.getWorldToScreenTransform());
                }
                finally {
                    renderer.removeRenderListener((RenderListener)this);
                }
            }
            if (this.cancelled) {
                return TaskResult.CANCELLED;
            }
            if (this.failed) {
                return TaskResult.FAILED;
            }
            return TaskResult.COMPLETED;
        }

        public synchronized void cancel() {
            if (RenderingExecutor.this.isRunning()) {
                this.cancelled = true;
                RenderingExecutor.this.mapPane.getRenderer().stopRendering();
            }
        }

        public void featureRenderer(SimpleFeature feature) {
            RenderingExecutor renderingExecutor = RenderingExecutor.this;
            renderingExecutor.numFeatures = renderingExecutor.numFeatures + 1L;
        }

        public void errorOccurred(Exception e) {
            this.failed = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskResult {
        PENDING,
        COMPLETED,
        CANCELLED,
        FAILED;

    }
}

