/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.event.MouseInputListener;
import org.geotools.swing.JMapPane;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.tool.CursorTool;

public class MapToolManager
implements MouseInputListener,
MouseWheelListener {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    private JMapPane mapPane;
    private Set<MapMouseListener> listeners = new HashSet<MapMouseListener>();
    private CursorTool cursorTool;

    public MapToolManager(JMapPane pane) {
        this.mapPane = pane;
    }

    public void setNoCursorTool() {
        this.listeners.remove(this.cursorTool);
        this.cursorTool = null;
    }

    public boolean setCursorTool(CursorTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        if (this.cursorTool != null) {
            this.listeners.remove(this.cursorTool);
        }
        this.cursorTool = tool;
        this.cursorTool.setMapPane(this.mapPane);
        return this.listeners.add(tool);
    }

    public CursorTool getCursorTool() {
        return this.cursorTool;
    }

    public boolean addMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        return this.listeners.add(listener);
    }

    public boolean removeMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        return this.listeners.remove(listener);
    }

    public void mouseClicked(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseClicked(ev);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMousePressed(ev);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseReleased(ev);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseEntered(ev);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseExited(ev);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseDragged(ev);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseMoved(ev);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        MapMouseEvent ev = this.convertEvent(e);
        if (ev != null) {
            for (MapMouseListener listener : this.listeners) {
                listener.onMouseWheelMoved(ev);
            }
        }
    }

    private MapMouseEvent convertEvent(MouseEvent e) {
        MapMouseEvent ev = null;
        if (this.mapPane.getScreenToWorldTransform() != null) {
            ev = new MapMouseEvent(this.mapPane, e);
        }
        return ev;
    }

    private MapMouseEvent convertEvent(MouseWheelEvent e) {
        MapMouseEvent ev = null;
        if (this.mapPane.getScreenToWorldTransform() != null) {
            ev = new MapMouseEvent(this.mapPane, e);
        }
        return ev;
    }
}

