/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dndlist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnDListModel<T>
extends AbstractListModel {
    private static final long serialVersionUID = -6110074993686576005L;
    List<T> items = new ArrayList<T>();
    private boolean notify = true;

    public void setNofifyListeners(boolean notify) {
        this.notify = notify;
    }

    public boolean getNotifyListeners() {
        return this.notify;
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.items.get(index);
    }

    public List<T> getElementsAt(int[] indices) {
        ArrayList<T> refs = new ArrayList<T>();
        for (int k = 0; k < indices.length; ++k) {
            refs.add(this.items.get(indices[k]));
        }
        return refs;
    }

    public List<T> getElementsAt(Collection<Integer> indices) {
        ArrayList<T> refs = new ArrayList<T>();
        for (Integer index : indices) {
            refs.add(this.items.get(index));
        }
        return refs;
    }

    public void addItem(T newItem) {
        int index = this.items.size();
        this.items.add(newItem);
        if (this.notify) {
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void addItems(T[] newItems) {
        if (newItems.length > 0) {
            int index0 = this.items.size();
            for (T item : newItems) {
                this.items.add(item);
            }
            if (this.notify) {
                this.fireIntervalAdded(this, index0, index0 + newItems.length - 1);
            }
        }
    }

    public void addItems(Collection<T> newItems) {
        if (!newItems.isEmpty()) {
            int index0 = this.items.size();
            for (T item : newItems) {
                this.items.add(item);
            }
            if (this.notify) {
                this.fireIntervalAdded(this, index0, index0 + newItems.size() - 1);
            }
        }
    }

    public void insertItem(int destIndex, T newItem) {
        if (destIndex < 0) {
            destIndex = 0;
        } else if (destIndex >= this.getSize()) {
            this.addItem(newItem);
            return;
        }
        this.items.add(destIndex, newItem);
        if (this.notify) {
            this.fireIntervalAdded(this, destIndex, destIndex);
        }
    }

    public void insertItems(int destIndex, T[] newItems) {
        this.insertItems(destIndex, Arrays.asList(newItems));
    }

    public void insertItems(int destIndex, Collection<T> newItems) {
        if (destIndex < 0) {
            destIndex = 0;
        } else if (destIndex >= this.getSize()) {
            this.addItems(newItems);
            return;
        }
        this.items.addAll(destIndex, newItems);
        if (this.notify) {
            this.fireIntervalAdded(this, destIndex, destIndex + newItems.size() - 1);
        }
    }

    public void moveItems(int destIndex, int[] srcIndices) {
        if (srcIndices.length > 0) {
            List<T> copies = this.getElementsAt(srcIndices);
            int minIndex = Math.min(destIndex, srcIndices[0]);
            int maxIndex = Math.max(destIndex - 1, srcIndices[srcIndices.length - 1]);
            for (int k = srcIndices.length - 1; k >= 0; --k) {
                this.items.remove(srcIndices[k]);
            }
            this.notify = false;
            this.insertItems(destIndex, copies);
            this.fireContentsChanged(this, minIndex, maxIndex);
            this.notify = true;
        }
    }

    public void removeAt(int index) {
        this.items.remove(index);
        if (this.notify) {
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void removeItem(T item) {
        ListIterator<T> iter = this.items.listIterator();
        int index = 0;
        boolean found = false;
        while (iter.hasNext()) {
            T anItem = iter.next();
            if (anItem.equals(item)) {
                iter.remove();
                found = true;
                break;
            }
            ++index;
        }
        if (found && this.notify) {
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void clear() {
        int prevSize = this.items.size();
        this.items.clear();
        if (this.notify) {
            this.fireIntervalRemoved(this, 0, prevSize);
        }
    }

    public boolean contains(T item) {
        return this.items.contains(item);
    }

    public int indexOf(T item) {
        return this.items.indexOf(item);
    }

    public String toString() {
        return "DnD:" + this.items;
    }
}

