/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.event;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.swing.JMapPane;

public final class MapMouseEvent
extends MouseEvent {
    private static final long serialVersionUID = 3894658044662688321L;
    private DirectPosition2D geoCoords;
    private boolean isWheelEvent;
    private int wheelAmount;

    public MapMouseEvent(JMapPane pane, MouseEvent event) {
        super(pane, event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
        this.isWheelEvent = false;
        this.wheelAmount = 0;
        AffineTransform tr = pane.getScreenToWorldTransform();
        this.geoCoords = new DirectPosition2D((double)event.getX(), (double)event.getY());
        tr.transform((Point2D)this.geoCoords, (Point2D)this.geoCoords);
    }

    public MapMouseEvent(JMapPane pane, MouseWheelEvent event) {
        super(pane, event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger());
        this.isWheelEvent = true;
        this.wheelAmount = event.getWheelRotation();
    }

    public boolean isWheelEvent() {
        return this.isWheelEvent;
    }

    public int getWheelAmount() {
        return this.wheelAmount;
    }

    public DirectPosition2D getMapPosition() {
        return new DirectPosition2D(this.geoCoords.x, this.geoCoords.y);
    }
}

