/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.utils;

import java.util.Collection;
import java.util.Map;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.map.MapLayer;
import org.geotools.util.KVP;
import org.opengis.feature.type.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapLayerUtils {
    public static final String IS_GRID_KEY = "is_grid";
    public static final String IS_GRID_READER_KEY = "is_grid_reader";
    public static final String GRID_ATTR_KEY = "grid_attr";

    public static Map<String, Object> isGridLayer(MapLayer layer) {
        KVP info = new KVP(new Object[]{IS_GRID_KEY, Boolean.FALSE, IS_GRID_READER_KEY, Boolean.FALSE, GRID_ATTR_KEY, ""});
        Collection descriptors = layer.getFeatureSource().getSchema().getDescriptors();
        for (PropertyDescriptor desc : descriptors) {
            Class clazz = desc.getType().getBinding();
            if (GridCoverage2D.class.isAssignableFrom(clazz)) {
                info.put((Object)IS_GRID_KEY, (Object)Boolean.TRUE);
                info.put((Object)GRID_ATTR_KEY, (Object)desc.getName().getLocalPart());
                break;
            }
            if (!AbstractGridCoverage2DReader.class.isAssignableFrom(clazz)) continue;
            info.put((Object)IS_GRID_KEY, (Object)Boolean.TRUE);
            info.put((Object)IS_GRID_READER_KEY, (Object)Boolean.TRUE);
            info.put((Object)GRID_ATTR_KEY, (Object)desc.getName().getLocalPart());
            break;
        }
        return info;
    }
}

