/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.swing.MapLayerTable;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.event.MapPaneListener;
import org.geotools.swing.tool.CursorTool;
import org.geotools.swing.tool.MapToolManager;
import org.opengis.geometry.Envelope;

public class JMapPane
extends JPanel
implements MapLayerListListener,
MapBoundsListener {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    public static final int DEFAULT_RESIZING_PAINT_DELAY = 500;
    private Timer resizeTimer;
    private int resizingPaintDelay = 500;
    private boolean acceptRepaintRequests = true;
    private ReferencedEnvelope pendingDisplayArea;
    private ReferencedEnvelope fullExtent;
    private DragBox dragBox;
    private MapContext context;
    private GTRenderer renderer;
    private LabelCache labelCache;
    private MapToolManager toolManager;
    private MapLayerTable layerTable;
    private Set<MapPaneListener> listeners = new HashSet<MapPaneListener>();
    private AffineTransform worldToScreen;
    private AffineTransform screenToWorld;
    private Rectangle curPaintArea;
    private BufferedImage baseImage;
    private Point imageOrigin = new Point(0, 0);
    private boolean redrawBaseImage = true;
    private boolean needNewBaseImage = true;
    private boolean baseImageMoved = false;

    public JMapPane() {
        this(null, null);
    }

    public JMapPane(GTRenderer renderer, MapContext context) {
        this.resizeTimer = new Timer(this.resizingPaintDelay, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMapPane.this.onResizingCompleted();
            }
        });
        this.resizeTimer.setRepeats(false);
        this.setRenderer(renderer);
        this.setMapContext(context);
        this.toolManager = new MapToolManager(this);
        this.dragBox = new DragBox();
        this.addMouseListener(this.dragBox);
        this.addMouseMotionListener(this.dragBox);
        this.addMouseListener(this.toolManager);
        this.addMouseMotionListener(this.toolManager);
        this.addMouseWheelListener(this.toolManager);
        this.addMouseListener(new MouseInputAdapter(){

            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                CursorTool tool = JMapPane.this.toolManager.getCursorTool();
                if (tool != null) {
                    JMapPane.this.setCursor(tool.getCursor());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                JMapPane.this.acceptRepaintRequests = false;
                JMapPane.this.resizeTimer.restart();
            }
        });
    }

    private void onResizingCompleted() {
        this.acceptRepaintRequests = true;
        this.needNewBaseImage = true;
        this.curPaintArea = this.getVisibleRect();
        --this.curPaintArea.width;
        --this.curPaintArea.height;
        if (this.context != null && this.context.getLayerCount() > 0) {
            if (this.fullExtent == null) {
                this.setFullExtent();
            }
            if (this.pendingDisplayArea != null) {
                this.doSetDisplayArea((Envelope)this.pendingDisplayArea);
                this.pendingDisplayArea = null;
            } else {
                this.doSetDisplayArea((Envelope)this.context.getAreaOfInterest());
            }
            this.repaint();
            MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.PANE_RESIZED);
            this.publishEvent(ev);
        }
    }

    public void setCursorTool(CursorTool tool) {
        if (tool == null) {
            this.toolManager.setNoCursorTool();
            this.setCursor(Cursor.getDefaultCursor());
            this.dragBox.setEnabled(false);
        } else {
            this.setCursor(tool.getCursor());
            this.toolManager.setCursorTool(tool);
            this.dragBox.setEnabled(tool.drawDragBox());
        }
    }

    public void addMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        this.toolManager.addMouseListener(listener);
    }

    public void removeMouseListener(MapMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        this.toolManager.removeMouseListener(listener);
    }

    public void addMapPaneListener(MapPaneListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        this.listeners.add(listener);
    }

    public void setMapLayerTable(MapLayerTable layerTable) {
        if (layerTable == null) {
            throw new IllegalArgumentException(stringRes.getString("arg_null_error"));
        }
        this.layerTable = layerTable;
    }

    public GTRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(GTRenderer renderer) {
        if (renderer instanceof StreamingRenderer) {
            HashMap<String, LabelCache> hints = renderer.getRendererHints();
            if (hints == null) {
                hints = new HashMap<String, LabelCache>();
            }
            if (hints.containsKey("labelCache")) {
                this.labelCache = (LabelCache)hints.get("labelCache");
            } else {
                this.labelCache = new LabelCacheImpl();
                hints.put("labelCache", this.labelCache);
            }
            renderer.setRendererHints(hints);
        }
        this.renderer = renderer;
        if (this.context != null) {
            this.renderer.setContext(this.context);
        }
    }

    public MapContext getMapContext() {
        return this.context;
    }

    public void setMapContext(MapContext context) {
        if (this.context != context) {
            if (this.context != null) {
                this.context.removeMapLayerListListener((MapLayerListListener)this);
                for (MapLayer layer : this.context.getLayers()) {
                    if (!(layer instanceof ComponentListener)) continue;
                    this.removeComponentListener((ComponentListener)layer);
                }
            }
            this.context = context;
            if (context != null) {
                this.context.addMapLayerListListener((MapLayerListListener)this);
                this.context.addMapBoundsListener((MapBoundsListener)this);
                for (MapLayer layer : context.getLayers()) {
                    layer.setSelected(true);
                    if (!(layer instanceof ComponentListener)) continue;
                    this.addComponentListener((ComponentListener)layer);
                }
                this.setFullExtent();
            }
            if (this.renderer != null) {
                this.renderer.setContext(this.context);
            }
            MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.NEW_CONTEXT);
            this.publishEvent(ev);
        }
    }

    public ReferencedEnvelope getDisplayArea() {
        ReferencedEnvelope aoi = null;
        if (this.curPaintArea != null && this.screenToWorld != null) {
            Point2D.Double p0 = new Point2D.Double(this.curPaintArea.getMinX(), this.curPaintArea.getMinY());
            Point2D.Double p1 = new Point2D.Double(this.curPaintArea.getMaxX(), this.curPaintArea.getMaxY());
            this.screenToWorld.transform(p0, p0);
            this.screenToWorld.transform(p1, p1);
            aoi = new ReferencedEnvelope(Math.min(((Point2D)p0).getX(), ((Point2D)p1).getX()), Math.max(((Point2D)p0).getX(), ((Point2D)p1).getX()), Math.min(((Point2D)p0).getY(), ((Point2D)p1).getY()), Math.max(((Point2D)p0).getY(), ((Point2D)p1).getY()), this.context.getCoordinateReferenceSystem());
        }
        return aoi;
    }

    public void setDisplayArea(Envelope envelope) {
        if (this.context != null) {
            if (this.curPaintArea == null || this.curPaintArea.isEmpty()) {
                this.pendingDisplayArea = new ReferencedEnvelope(envelope);
            } else {
                this.doSetDisplayArea(envelope);
                this.labelCache.clear();
                this.repaint();
            }
        } else {
            throw new IllegalStateException("Map context must be set before setting the display area");
        }
    }

    private void doSetDisplayArea(Envelope envelope) {
        assert (this.context != null && this.curPaintArea != null && !this.curPaintArea.isEmpty());
        if (this.equalsFullExtent(envelope)) {
            this.setTransforms((Envelope)this.fullExtent, this.curPaintArea);
        } else {
            this.setTransforms(envelope, this.curPaintArea);
        }
        ReferencedEnvelope adjustedEnvelope = this.getDisplayArea();
        this.context.setAreaOfInterest(adjustedEnvelope);
        MapPaneEvent ev = new MapPaneEvent(this, MapPaneEvent.Type.DISPLAY_AREA_CHANGED);
        this.publishEvent(ev);
    }

    private boolean equalsFullExtent(Envelope envelope) {
        assert (this.fullExtent != null);
        double TOL = 1.0E-6 * (this.fullExtent.getWidth() + this.fullExtent.getHeight());
        boolean touch = false;
        if (Math.abs(envelope.getMinimum(0) - this.fullExtent.getMinimum(0)) < TOL) {
            touch = true;
        }
        if (Math.abs(envelope.getMaximum(0) - this.fullExtent.getMaximum(0)) < TOL && touch) {
            return true;
        }
        if (Math.abs(envelope.getMinimum(1) - this.fullExtent.getMinimum(1)) < TOL) {
            touch = true;
        }
        return Math.abs(envelope.getMaximum(1) - this.fullExtent.getMaximum(1)) < TOL && touch;
    }

    public void reset() {
        if (this.fullExtent != null) {
            this.setDisplayArea((Envelope)this.fullExtent);
        }
    }

    public void setRepaint(boolean repaint) {
        this.acceptRepaintRequests = repaint;
        this.setIgnoreRepaint(!repaint);
    }

    public boolean isAcceptingRepaints() {
        return this.acceptRepaintRequests;
    }

    public RenderedImage getBaseImage() {
        return this.baseImage;
    }

    public int getResizeDelay() {
        return this.resizingPaintDelay;
    }

    public void setResizeDelay(int delay) {
        this.resizingPaintDelay = delay < 0 ? 500 : delay;
    }

    public AffineTransform getScreenToWorldTransform() {
        if (this.screenToWorld != null) {
            return new AffineTransform(this.screenToWorld);
        }
        return null;
    }

    public AffineTransform getWorldToScreenTransform() {
        if (this.worldToScreen != null) {
            return new AffineTransform(this.worldToScreen);
        }
        return null;
    }

    public void moveImage(int dx, int dy) {
        this.imageOrigin.translate(dx, dy);
        this.redrawBaseImage = false;
        this.baseImageMoved = true;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.acceptRepaintRequests) {
            ReferencedEnvelope mapAOI;
            if (this.context == null || this.renderer == null) {
                return;
            }
            if (this.curPaintArea == null) {
                return;
            }
            if (this.needNewBaseImage) {
                this.baseImage = new BufferedImage(this.curPaintArea.width + 1, this.curPaintArea.height + 1, 2);
                this.needNewBaseImage = false;
                this.redrawBaseImage = true;
                this.labelCache.clear();
            }
            if ((mapAOI = this.context.getAreaOfInterest()) == null) {
                return;
            }
            if (this.redrawBaseImage) {
                if (this.baseImageMoved) {
                    this.afterImageMove(mapAOI, this.curPaintArea);
                    this.baseImageMoved = false;
                    this.labelCache.clear();
                }
                this.clearBaseImage();
                Graphics2D baseGr = this.baseImage.createGraphics();
                this.renderer.paint(baseGr, this.curPaintArea, mapAOI, this.worldToScreen);
            }
            ((Graphics2D)g).drawImage((Image)this.baseImage, this.imageOrigin.x, this.imageOrigin.y, this);
            this.redrawBaseImage = true;
        }
    }

    protected void afterImageMove(ReferencedEnvelope env, Rectangle paintArea) {
        int dx = this.imageOrigin.x;
        int dy = this.imageOrigin.y;
        DirectPosition2D newPos = new DirectPosition2D((double)dx, (double)dy);
        this.screenToWorld.transform((Point2D)newPos, (Point2D)newPos);
        env.translate(env.getMinimum(0) - newPos.x, env.getMaximum(1) - newPos.y);
        this.doSetDisplayArea((Envelope)env);
        this.imageOrigin.setLocation(0, 0);
    }

    public void layerAdded(MapLayerListEvent event) {
        if (this.layerTable != null) {
            this.layerTable.onAddLayer(event.getLayer());
        }
        MapLayer layer = event.getLayer();
        layer.setSelected(true);
        if (layer instanceof ComponentListener) {
            this.addComponentListener((ComponentListener)layer);
        }
        if (this.context.getLayerCount() == 1) {
            this.setFullExtent();
            this.reset();
        }
        this.repaint();
    }

    public void layerRemoved(MapLayerListEvent event) {
        MapLayer layer = event.getLayer();
        if (this.layerTable != null) {
            this.layerTable.onRemoveLayer(layer);
        }
        if (layer instanceof ComponentListener) {
            this.addComponentListener((ComponentListener)layer);
        }
        this.setFullExtent();
        this.repaint();
    }

    public void layerChanged(MapLayerListEvent event) {
        int reason;
        if (this.layerTable != null) {
            this.layerTable.repaint(event.getLayer());
        }
        if ((reason = event.getMapLayerEvent().getReason()) == 3) {
            this.setFullExtent();
        }
        if (reason != 6) {
            this.repaint();
        }
    }

    public void layerMoved(MapLayerListEvent event) {
        this.repaint();
    }

    public void mapBoundsChanged(MapBoundsEvent event) {
        int type = event.getType();
        if ((type & 2) != 0) {
            this.setFullExtent();
            this.reset();
        }
    }

    private void setFullExtent() {
        if (this.context != null && this.context.getLayerCount() > 0) {
            try {
                this.fullExtent = this.context.getLayerBounds();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            this.fullExtent = null;
        }
    }

    private void setTransforms(Envelope envelope, Rectangle paintArea) {
        ReferencedEnvelope refEnv = new ReferencedEnvelope(envelope);
        double xscale = paintArea.getWidth() / refEnv.getWidth();
        double yscale = paintArea.getHeight() / refEnv.getHeight();
        double scale = Math.min(xscale, yscale);
        double xoff = refEnv.getMedian(0) * scale - paintArea.getCenterX();
        double yoff = refEnv.getMedian(1) * scale + paintArea.getCenterY();
        this.worldToScreen = new AffineTransform(scale, 0.0, 0.0, -scale, -xoff, yoff);
        try {
            this.screenToWorld = this.worldToScreen.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
    }

    private void clearBaseImage() {
        assert (this.baseImage != null);
        Graphics2D g2D = this.baseImage.createGraphics();
        g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.baseImage.getWidth(), this.baseImage.getHeight());
        g2D.fill(rect);
    }

    private void publishEvent(MapPaneEvent ev) {
        for (MapPaneListener listener : this.listeners) {
            switch (ev.getType()) {
                case NEW_CONTEXT: {
                    listener.onNewContext(ev);
                    break;
                }
                case NEW_RENDERER: {
                    listener.onNewRenderer(ev);
                    break;
                }
                case PANE_RESIZED: {
                    listener.onResized(ev);
                    break;
                }
                case DISPLAY_AREA_CHANGED: {
                    listener.onDisplayAreaChanged(ev);
                }
            }
        }
    }

    private class DragBox
    extends MouseInputAdapter {
        private Point startPos;
        private Rectangle rect = new Rectangle();
        private boolean dragged = false;
        private boolean enabled = false;

        DragBox() {
        }

        void setEnabled(boolean state) {
            this.enabled = state;
        }

        public void mousePressed(MouseEvent e) {
            this.startPos = new Point(e.getPoint());
        }

        public void mouseDragged(MouseEvent e) {
            if (this.enabled) {
                Graphics2D g2D = (Graphics2D)JMapPane.this.getGraphics();
                g2D.setColor(Color.WHITE);
                g2D.setXORMode(Color.RED);
                if (this.dragged) {
                    g2D.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                }
                this.rect.setFrameFromDiagonal(this.startPos, e.getPoint());
                g2D.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                this.dragged = true;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragged) {
                Graphics2D g2D = (Graphics2D)JMapPane.this.getGraphics();
                g2D.setColor(Color.WHITE);
                g2D.setXORMode(Color.RED);
                g2D.drawRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                this.dragged = false;
            }
        }
    }
}

