/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2010(c).
 * 
 * file: TerralibQueryCapabilities.java
 * created: May 12, 2010
 */
package org.geotools.data.terralib.feature;

import org.geotools.data.QueryCapabilities;
import org.opengis.filter.sort.SortBy;

/**
 * Extension of AbstractFeatureSource's QueryCapabilities, to inform that
 * Terralib support sorting and offset.
 * @author fabiomano
 * @since TDK 3.1
 */
public class TerralibQueryCapabilities extends QueryCapabilities
{
    /* (non-Javadoc)
     * @see org.geotools.data.QueryCapabilities#supportsSorting(org.opengis.filter.sort.SortBy[])
     */
    @Override
    public boolean supportsSorting(SortBy[] sortAttributes)
    {
        return true;
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.QueryCapabilities#isOffsetSupported()
     */
    @Override
    public boolean isOffsetSupported()
    {
        return true;
    }
}
