/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: QuerierParams.java
 * created: 12/01/2009
 */
package org.geotools.data.terralib.query;


import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.data.terralib.FeatureTypeInfo;
import org.geotools.data.terralib.swig.QuerierParamsNative;
import org.opengis.filter.Filter;

/**
 * @author fmoura
 * @since TDK 3.0.0
 */
public class QuerierParams extends QuerierParamsNative
{
   private FeatureTypeInfo _featureTypeInfo;
   private Query _query;

   public QuerierParams(FeatureTypeInfo featureTypeInfo)
   {
       this(featureTypeInfo,new DefaultQuery(featureTypeInfo.getTypeName(),Filter.INCLUDE));
   }
   
   /**
     * @param typeName
     */
    public QuerierParams(FeatureTypeInfo featureTypeInfo, Query query)
    {
        super(featureTypeInfo.getTypeName());
        _featureTypeInfo = featureTypeInfo;
        _query = query;
    }

    /**
     * @return
     * @since
     */
    public FeatureTypeInfo getFeatureTypeInfo()
    {

        return _featureTypeInfo;
    }
    
    /**
     * Returns the filter for the query
     * Same as calling getQuery.getFilter()
     * @return The filter
     */
    public Filter getFilter()
    {
        return _query.getFilter();
    }

    /**
     * Returns the current Query. 
     * @return
     */
    public Query getQuery()
    {
        return _query;
    }
    
}
