/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: QueryData.java
 * created: 14/01/2009
 */
package org.geotools.data.terralib.query;

import java.io.IOException;

import org.geotools.data.AttributeReader;
import org.geotools.data.AttributeWriter;

/**
 * @author fmoura
 * @since TDK3.0.0
 */
public interface QueryData extends AttributeReader, AttributeWriter
{
    /**
     * Writes and/or updates features in the database.
     * @param writeOnlyGeometries indicates if this object should write only the geometries attributes to the database.
     * @throws IOException if an error occurs during the feature persistence 
     * @since TDK 3.0.0
     */
    void flush(boolean writeOnlyGeometries) throws IOException;
    
    
    /**
     * Checks if the QueryData is closed.
     * @return True if it's closed, false otherwise
     * @since TDK 3.0.0
     */
    public boolean isClosed();
    
    
    /**
     * Gets the current feature's object_id (unique identifier for the terralib)
     * @return the current feature's object_id
     */
    public String getObjectId();
    
    /**
     * Sets the current feature's object_id (unique identifier for the terralib)
     * @param objectId The new object id for the current feature
     */
    public void setObjectId(String objectId);    
}
