/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2010(c).
 * 
 * file: AccessQueryChecker.java
 * created: May 10, 2010
 */
package org.geotools.data.terralib.query.check;

import org.geotools.data.Query;

/**
 * Implement query checker for Access database. 
 * @author fabiomano
 * @since TDK 3.1
 */
public class AccessQueryChecker implements QueryChecker
{

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.check.QueryChecker#checkQuery(org.geotools.data.Query)
     */
    @Override
    public void checkQuery(Query query) throws UnsupportedOperationException
    {
        if (query != null)
        {
            if ((query.getStartIndex() != null) && (query.getStartIndex() > 1))
                throw new UnsupportedOperationException("Start Index parameter is not supported at Access database");
            
            if (query.getMaxFeatures() != Query.DEFAULT_MAX)
                throw new UnsupportedOperationException("Max Features parameter is not supported at Access database");
        }
    }

}
