/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2010(c).
 * 
 * file: TerralibFilterToSQLException.java
 * created: Apr 13, 2010
 */
package org.geotools.data.terralib.query.filter;

import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;

/**
 * Exception throw by TerralibFilterToSQL when the filter or expression can't be
 * translated to a sql query.
 * @author fabiomano
 * @since TDK 3.1
 */
public class TerralibFilterToSQLException extends RuntimeException
{
    private static final long serialVersionUID = -8604628541193996006L;

    public TerralibFilterToSQLException(Filter filter, String reason)
    {
        super("The filter " + filter.toString() + " can't be translated to a SQL statement due to: " + reason);
    }
    
    public TerralibFilterToSQLException(Expression expression, String reason)
    {
        super("The expression " + expression.toString() + " can't be translated to a SQL statement due to: " + reason);
    }    
}
