/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2010(c).
 * 
 * file: CppPortal.java
 * created: Apr 16, 2010
 */
package org.geotools.data.terralib.query.portal;

import java.io.IOException;

import org.geotools.data.terralib.TerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.geometry.MultiTextGeometry;
import org.geotools.data.terralib.swig.DatabasePortal;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;

/**
 * C++ implementation of a Portal, uses C++ Terralib Provider. 
 * @author fabiomano
 * @since TDK 3.1
 */
public class CppPortal implements Portal
{
    private DatabasePortal _target;
    private TerralibService _terralibService;
    private String _lockUUID;
    private boolean _lockReleased;
    
    public CppPortal(DatabasePortal target, TerralibService service, String lockUUID)
    {
        if (target == null)
            throw new NullArgumentException("target");
        if (service == null)
            throw new NullArgumentException("service");
        _target = target;
        _terralibService = service;
        _lockUUID = lockUUID;
        _lockReleased = false;
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#close()
     */
    @Override
    public void close()
    {
        synchronized (this)
        {
            _terralibService.releaseLock(_lockUUID);
            _lockReleased = true;
        }
        _target.freeResult();
    }

    /*
     * (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#finalizePortal()
     */
    @Override
    public void finalizePortal()
    {
        synchronized (this)
        {
            if (! _lockReleased)
                _terralibService.releaseLock(_lockUUID);
        }
        _target.setToFreeNativeTarget(true);
        _target.delete();        
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#fetchLine()
     */
    @Override
    public MultiLineString fetchLine() throws IOException
    {
        return _target.fetchLine();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#fetchPoint()
     */
    @Override
    public MultiPoint fetchPoint() throws IOException
    {
        return _target.fetchPoint();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#fetchPolygon()
     */
    @Override
    public MultiPolygon fetchPolygon() throws IOException
    {
        return _target.fetchPolygon();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#fetchText()
     */
    @Override
    public MultiTextGeometry fetchText() throws IOException
    {
        return _target.fetchText();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#getDate(java.lang.String)
     */
    @Override
    public String getDate(String fieldName)
    {
        return _target.getDate(fieldName);
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#getDouble(java.lang.String)
     */
    @Override
    public double getDouble(String fieldName)
    {
        return _target.getDouble(fieldName);
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#getInt(java.lang.String)
     */
    @Override
    public int getInt(String fieldName)
    {
        return _target.getInt(fieldName);
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#getString(java.lang.String)
     */
    @Override
    public String getString(String fieldName)
    {
        return _target.getString(fieldName);
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#hasNext()
     */
    @Override
    public boolean hasNext()
    {
        return _target.hasNext();
    }

    /* (non-Javadoc)
     * @see org.geotools.data.terralib.query.portal.Portal#isClosed()
     */
    @Override
    public boolean isClosed()
    {
        return _target.isClosed();
    }

}
