/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.query;

import java.io.IOException;
import org.geotools.data.terralib.DefaultTerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TypeNotFoundException;
import org.geotools.data.terralib.query.QuerierParams;
import org.geotools.data.terralib.query.QueryData;
import org.geotools.data.terralib.query.TerralibQueryData;
import org.geotools.data.terralib.query.portal.CppPortal;
import org.geotools.data.terralib.swig.QuerierNative;

public class Querier
extends QuerierNative {
    private DefaultTerralibService _terralibService;

    public Querier(DefaultTerralibService terralibService) {
        super(terralibService);
        this._terralibService = terralibService;
    }

    public QueryData execute(QuerierParams params) throws IOException, TypeNotFoundException {
        String uuid = this._terralibService.getLock();
        try {
            CppPortal portal = new CppPortal(super.execute(params), this._terralibService, uuid);
            return new TerralibQueryData(this._terralibService, portal, params.getFeatureTypeInfo());
        }
        catch (IOException e) {
            this._terralibService.releaseLock(uuid);
            throw e;
        }
        catch (TypeNotFoundException e) {
            this._terralibService.releaseLock(uuid);
            throw e;
        }
        catch (NullArgumentException e) {
            this._terralibService.releaseLock(uuid);
            throw e;
        }
        catch (Throwable e) {
            this._terralibService.releaseLock(uuid);
            throw new RuntimeException(e);
        }
    }
}

