/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.swig;

import org.apache.log4j.Logger;
import org.geotools.data.terralib.swig.CoreJNI;
import org.geotools.data.terralib.swig.SWIGTYPE_p_TeDatabase;

public class DBConnection {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private static final Logger _logger = Logger.getLogger(DBConnection.class);

    protected DBConnection(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DBConnection obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void setToFreeNativeTarget(boolean isToFreenativeTarget) {
        this.swigCMemOwn = isToFreenativeTarget;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            CoreJNI.delete_DBConnection(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    protected SWIGTYPE_p_TeDatabase getDatabase() {
        long cPtr = CoreJNI.DBConnection_getDatabase(this.swigCPtr, this);
        return cPtr == 0L ? null : new SWIGTYPE_p_TeDatabase(cPtr, false);
    }

    public void connect() {
        CoreJNI.DBConnection_connect(this.swigCPtr, this);
    }

    public boolean isConnected() {
        return CoreJNI.DBConnection_isConnected(this.swigCPtr, this);
    }

    public void disconnect() {
        CoreJNI.DBConnection_disconnect(this.swigCPtr, this);
    }
}

