/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.swig;

import org.apache.log4j.Logger;
import org.geotools.data.terralib.swig.CoreJNI;
import org.geotools.data.terralib.swig.DBConnection;
import org.geotools.data.terralib.swig.SWIGTYPE_p_TeDatabase;

public class DBConnectionFactoryNative {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private static final Logger _logger = Logger.getLogger(DBConnectionFactoryNative.class);

    protected DBConnectionFactoryNative(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DBConnectionFactoryNative obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void setToFreeNativeTarget(boolean isToFreenativeTarget) {
        this.swigCMemOwn = isToFreenativeTarget;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            CoreJNI.delete_DBConnectionFactoryNative(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public DBConnectionFactoryNative() {
        this(CoreJNI.new_DBConnectionFactoryNative(), true);
    }

    public DBConnection createAccessConnection(String path) {
        long cPtr = CoreJNI.DBConnectionFactoryNative_createAccessConnection(this.swigCPtr, this, path);
        return cPtr == 0L ? null : new DBConnection(cPtr, false);
    }

    public DBConnection createSQLServerConnection(String host, String userName, String password, String databaseName, int portNumber) {
        long cPtr = CoreJNI.DBConnectionFactoryNative_createSQLServerConnection__SWIG_0(this.swigCPtr, this, host, userName, password, databaseName, portNumber);
        return cPtr == 0L ? null : new DBConnection(cPtr, false);
    }

    public DBConnection createSQLServerConnection(String host, String userName, String password, String databaseName) {
        long cPtr = CoreJNI.DBConnectionFactoryNative_createSQLServerConnection__SWIG_1(this.swigCPtr, this, host, userName, password, databaseName);
        return cPtr == 0L ? null : new DBConnection(cPtr, false);
    }

    public void loadLayerData(SWIGTYPE_p_TeDatabase database) {
        CoreJNI.DBConnectionFactoryNative_loadLayerData(this.swigCPtr, this, SWIGTYPE_p_TeDatabase.getCPtr(database));
    }

    public void loadThemeData(SWIGTYPE_p_TeDatabase database) {
        CoreJNI.DBConnectionFactoryNative_loadThemeData(this.swigCPtr, this, SWIGTYPE_p_TeDatabase.getCPtr(database));
    }
}

