/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.network;

import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.graph.build.line.LineStringGraphGenerator;
import org.geotools.graph.structure.Graph;
import org.geotools.validation.DefaultIntegrityValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;

public class OrphanNodeValidation
extends DefaultIntegrityValidation {
    private String typeName;

    public String[] getTypeRefs() {
        return new String[]{this.typeName};
    }

    public boolean validate(Map layers, ReferencedEnvelope envelope, ValidationResults results) throws Exception {
        FeatureCollection fr;
        LineStringGraphGenerator lgb = new LineStringGraphGenerator();
        FeatureSource fs = (FeatureSource)layers.get(this.typeName);
        FeatureCollection fc = fr = fs.getFeatures();
        FeatureIterator f = fc.features();
        while (f.hasNext()) {
            SimpleFeature ft = (SimpleFeature)f.next();
            if (!envelope.contains(ft.getBounds())) continue;
            lgb.add(ft.getDefaultGeometry());
        }
        Graph g = lgb.getGraph();
        return g.getNodesOfDegree(0).size() == 0;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

