/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultRepository;
import org.geotools.data.FeatureSource;
import org.geotools.data.Repository;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.validation.Validation;
import org.geotools.validation.ValidationProcessor;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses");
    private ValidationProcessor validationProcessor;
    private DefaultRepository repository;

    public Validator(Repository repository, ValidationProcessor processor) {
        this.repository = (DefaultRepository)repository;
        this.validationProcessor = processor;
    }

    public void featureValidation(String dsid, FeatureCollection<SimpleFeatureType, SimpleFeature> features, ValidationResults results) throws IOException, Exception {
        if (this.validationProcessor == null) {
            LOGGER.warning("ValidationProcessor unavailable");
            return;
        }
        try {
            this.validationProcessor.runFeatureTests(dsid, features, results);
        }
        catch (Exception badIdea) {
            throw new DataSourceException("Validation Failed", (Throwable)badIdea);
        }
    }

    private ValidationResults makeFeatureValidationResults(final Map failed) {
        ValidationResults results = new ValidationResults(){
            String name;
            String description;

            public void setValidation(Validation validation) {
                this.name = validation.getName();
                this.description = validation.getDescription();
            }

            public void error(SimpleFeature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
                failed.put(feature.getID(), this.name + ": " + message + " " + "(" + this.description + ")");
            }

            public void warning(SimpleFeature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
            }
        };
        return results;
    }

    public void integrityValidation(Map<Name, FeatureSource<?, ?>> featureStores, ReferencedEnvelope bBox, ValidationResults results) throws IOException, Exception {
        if (this.validationProcessor == null) {
            LOGGER.warning("Validation Processor unavaialble");
            return;
        }
        LOGGER.finer("Required to validate " + featureStores.size() + " typeRefs");
        LOGGER.finer("within " + bBox);
        HashSet<String> typeRefs = new HashSet<String>();
        for (Name name : featureStores.keySet()) {
            String typeRef = this.typeRef(name);
            typeRefs.add(typeRef);
            Set dependencies = this.validationProcessor.getDependencies(typeRef);
            LOGGER.finer("typeRef " + typeRef + " requires " + dependencies);
            if (dependencies == null || dependencies.size() <= 0) continue;
            typeRefs.addAll(dependencies);
        }
        HashMap<String, Object> sources = new HashMap<String, Object>();
        for (String typeRef : typeRefs) {
            LOGGER.finer("Searching for required typeRef: " + typeRef);
            if (featureStores.containsKey(typeRef)) {
                LOGGER.finer(" found required typeRef: " + typeRef + " (it was already loaded)");
                sources.put(typeRef, featureStores.get(typeRef));
                continue;
            }
            LOGGER.finer(" could not find typeRef: " + typeRef + " (we will now load it)");
            String[] split = typeRef.split(":");
            String dataStoreId = split[0];
            String typeName = split[1];
            LOGGER.finer(" going to look for dataStoreId:" + dataStoreId + " and typeName:" + typeName);
            LOGGER.finer(" loaded required typeRef: " + typeRef);
            FeatureSource source = this.repository.source(dataStoreId, typeName);
            sources.put(typeRef, source);
        }
        LOGGER.finer("Total of " + sources.size() + " FeatureSource<SimpleFeatureType, SimpleFeature> marshalled for testing");
        TreeMap failed = new TreeMap();
        try {
            LOGGER.finer("Runing integrity tests using validation validationProcessor ");
            this.validationProcessor.runIntegrityTests(featureStores.keySet(), sources, bBox, results);
        }
        catch (Exception badIdea) {
            badIdea.printStackTrace();
            throw new DataSourceException("Validation Failed", (Throwable)badIdea);
        }
        if (failed.isEmpty()) {
            LOGGER.finer("All validation tests passed");
            return;
        }
        LOGGER.finer("Validation fail - marshal result for transaction document");
        StringBuffer message = new StringBuffer();
        for (Map.Entry entry : failed.entrySet()) {
            message.append(entry.getKey());
            message.append(" failed test ");
            message.append(entry.getValue());
            message.append("\n");
        }
    }

    protected String typeRef(Name name) {
        return name.getNamespaceURI() + ":" + name.getLocalPart();
    }

    private ValidationResults makeIntegrityValidationResults(final Map failed) {
        ValidationResults results = new ValidationResults(){
            String name;
            String description;

            public void setValidation(Validation validation) {
                this.name = validation.getName();
                this.description = validation.getDescription();
            }

            public void error(SimpleFeature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
                if (feature == null) {
                    failed.put("ALL", this.name + ": " + message + " " + "(" + this.description + ")");
                } else {
                    failed.put(feature.getID(), this.name + ": " + message + " " + "(" + this.description + ")");
                }
            }

            public void warning(SimpleFeature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
            }
        };
        return results;
    }
}

