/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import java.util.Collections;
import java.util.List;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.ifc.VPFHeader;
import org.geotools.data.vpf.io.TableColumnDef;

public class TableHeader
implements VPFHeader,
DataTypesDefinition {
    private int headerLength = 0;
    private char byteOrder = (char)76;
    private String description = null;
    private String narrativeTable = null;
    private List columnDefs = null;

    public TableHeader(int length, char byteOrder, String description, String narrativeTable, List columnDefs) {
        this.headerLength = length;
        this.byteOrder = byteOrder;
        this.description = description;
        this.narrativeTable = narrativeTable;
        this.columnDefs = columnDefs;
    }

    public String toString() {
        String endLine = System.getProperty("line.separator");
        StringBuffer buff = new StringBuffer();
        buff.append(" length=" + this.headerLength + endLine);
        buff.append(" byteOrder=" + this.byteOrder + endLine);
        buff.append(" description=" + this.description + endLine);
        buff.append(" narrativeTable=" + this.narrativeTable + endLine);
        buff.append(" columnDefs:");
        if (this.columnDefs == null) {
            buff.append("null)");
        } else {
            for (int i = 0; i < this.columnDefs.size(); ++i) {
                buff.append(endLine + this.columnDefs.get(i).toString());
            }
            buff.append(endLine);
        }
        return buff.toString();
    }

    public int getLength() {
        return this.headerLength + 4;
    }

    public int getRecordSize() {
        int size = 0;
        for (int i = 0; i < this.columnDefs.size(); ++i) {
            TableColumnDef colDef = (TableColumnDef)this.columnDefs.get(i);
            if (colDef.getColumnSize() < 0) {
                return -1;
            }
            size += colDef.getColumnSize();
        }
        return size;
    }

    public char getByteOrder() {
        return this.byteOrder;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNarrativeTable() {
        return this.narrativeTable;
    }

    public List getColumnDefs() {
        return Collections.unmodifiableList(this.columnDefs);
    }
}

