/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.protocol.http;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.geotools.data.wfs.protocol.http.HTTPProtocol;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpProtocol
implements HTTPProtocol {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs.protocol.http");
    private boolean tryGzip;
    protected String authUsername;
    protected String authPassword;
    protected int timeoutMillis = -1;

    @Override
    public boolean isTryGzip() {
        return this.tryGzip;
    }

    @Override
    public void setTryGzip(boolean tryGzip) {
        this.tryGzip = tryGzip;
    }

    @Override
    public void setAuth(String username, String password) {
        this.authUsername = username;
        this.authPassword = password;
    }

    @Override
    public boolean isAuthenticating() {
        return this.authUsername != null && this.authPassword != null;
    }

    @Override
    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public void setTimeoutMillis(int milliseconds) {
        this.timeoutMillis = milliseconds;
    }

    @Override
    public URL createUrl(URL baseUrl, Map<String, String> queryStringKvp) throws MalformedURLException {
        String finalUrlString = this.createUri(baseUrl, queryStringKvp);
        URL queryUrl = new URL(finalUrlString);
        return queryUrl;
    }

    protected String createUri(URL baseUrl, Map<String, String> queryStringKvp) {
        String query = baseUrl.getQuery();
        HashMap<String, String> finalKvpMap = new HashMap<String, String>(queryStringKvp);
        if (query != null && query.length() > 0) {
            String[] rawUrlKvpSet;
            CaseInsensitiveMap userParams = new CaseInsensitiveMap(queryStringKvp);
            for (String rawUrlKvp : rawUrlKvpSet = query.split("&")) {
                String value;
                String key;
                int eqIdx = rawUrlKvp.indexOf(61);
                if (eqIdx > 0) {
                    key = rawUrlKvp.substring(0, eqIdx);
                    value = rawUrlKvp.substring(eqIdx + 1);
                } else {
                    key = rawUrlKvp;
                    value = null;
                }
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                if (userParams.containsKey(key)) {
                    LOGGER.fine("user supplied value for query string argument " + key + " overrides the one in the base url");
                    continue;
                }
                finalKvpMap.put(key, value);
            }
        }
        String protocol = baseUrl.getProtocol();
        String host = baseUrl.getHost();
        int port = baseUrl.getPort();
        String path = baseUrl.getPath();
        StringBuilder sb = new StringBuilder();
        sb.append(protocol).append("://").append(host);
        if (port != -1 && port != baseUrl.getDefaultPort()) {
            sb.append(':');
            sb.append(port);
        }
        if (!"".equals(path) && !path.startsWith("/")) {
            sb.append('/');
        }
        sb.append(path).append('?');
        try {
            Iterator it = finalKvpMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry kvp = it.next();
                String key = (String)kvp.getKey();
                String value = (String)kvp.getValue();
                value = value == null ? "" : URLEncoder.encode(value, "UTF-8");
                sb.append(key);
                sb.append('=');
                sb.append(value);
                if (!it.hasNext()) continue;
                sb.append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String finalUrlString = sb.toString();
        return finalUrlString;
    }
}

