/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.LockingManager;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSServiceInfo;
import org.geotools.data.wfs.protocol.wfs.GetFeature;
import org.geotools.data.wfs.protocol.wfs.GetFeatureParser;
import org.geotools.data.wfs.protocol.wfs.WFSException;
import org.geotools.data.wfs.protocol.wfs.WFSExtensions;
import org.geotools.data.wfs.protocol.wfs.WFSOperationType;
import org.geotools.data.wfs.protocol.wfs.WFSProtocol;
import org.geotools.data.wfs.protocol.wfs.WFSResponse;
import org.geotools.data.wfs.v1_1_0.CapabilitiesServiceInfo;
import org.geotools.data.wfs.v1_1_0.GetFeatureQueryAdapter;
import org.geotools.data.wfs.v1_1_0.ReprojectingFilterVisitor;
import org.geotools.data.wfs.v1_1_0.WFSFeatureReader;
import org.geotools.data.wfs.v1_1_0.WFSFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WFS_1_1_0_DataStore
implements WFSDataStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private static final boolean DEFAULT_HTTP_METHOD = true;
    protected WFSProtocol wfs;
    private Map<String, SimpleFeatureType> byTypeNameTypes;
    private Integer maxFeaturesHardLimit;
    private boolean preferPostOverGet = false;
    private String namespaceOverride;

    public WFS_1_1_0_DataStore(WFSProtocol wfs) {
        if (wfs == null) {
            throw new NullPointerException("wfs protocol");
        }
        this.wfs = wfs;
        this.byTypeNameTypes = Collections.synchronizedMap(new HashMap());
        this.maxFeaturesHardLimit = 0;
    }

    @Override
    public void setNamespaceOverride(String namespaceOverride) {
        this.namespaceOverride = namespaceOverride;
    }

    @Override
    public void setMaxFeatures(Integer maxFeatures) {
        this.maxFeaturesHardLimit = (int)maxFeatures;
    }

    @Override
    public Integer getMaxFeatures() {
        return this.maxFeaturesHardLimit;
    }

    @Override
    public boolean isPreferPostOverGet() {
        return this.preferPostOverGet;
    }

    @Override
    public void setPreferPostOverGet(Boolean booleanValue) {
        this.preferPostOverGet = booleanValue == null ? true : booleanValue;
    }

    @Override
    public WFSServiceInfo getInfo() {
        return new CapabilitiesServiceInfo(this);
    }

    public SimpleFeatureType getSchema(String prefixedTypeName) throws IOException {
        SimpleFeatureType ftype = this.byTypeNameTypes.get(prefixedTypeName);
        if (ftype == null) {
            SimpleFeatureType adaptedFeatureType;
            try {
                QName featureDescriptorName = this.wfs.getFeatureTypeName(prefixedTypeName);
            }
            catch (IllegalArgumentException e) {
                throw new SchemaNotFoundException(prefixedTypeName);
            }
            CoordinateReferenceSystem crs = this.getFeatureTypeCRS(prefixedTypeName);
            SimpleFeatureType featureType = this.wfs.issueDescribeFeatureTypeGET(prefixedTypeName, crs);
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.init(featureType);
            builder.setName(prefixedTypeName);
            builder.setNamespaceURI(this.namespaceOverride);
            GeometryDescriptor defaultGeometry = featureType.getGeometryDescriptor();
            if (defaultGeometry != null) {
                builder.setDefaultGeometry(defaultGeometry.getLocalName());
                builder.setCRS(defaultGeometry.getCoordinateReferenceSystem());
            }
            ftype = adaptedFeatureType = builder.buildFeatureType();
            this.byTypeNameTypes.put(prefixedTypeName, ftype);
        }
        return ftype;
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        Set<QName> featureTypeNames = this.wfs.getFeatureTypeNames();
        for (QName qname : featureTypeNames) {
            String namespaceURI = name.getNamespaceURI();
            String localPart = name.getLocalPart();
            if (!namespaceURI.equals(qname.getNamespaceURI()) || !localPart.equals(qname.getLocalPart())) continue;
            String prefixedName = qname.getPrefix() + ":" + localPart;
            return this.getSchema(prefixedName);
        }
        throw new SchemaNotFoundException(name.getURI());
    }

    public List<Name> getNames() throws IOException {
        Set<QName> featureTypeNames = this.wfs.getFeatureTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(featureTypeNames.size());
        for (QName name : featureTypeNames) {
            String namespaceURI = name.getNamespaceURI();
            String localPart = name.getLocalPart();
            names.add((Name)new NameImpl(namespaceURI, localPart));
        }
        return names;
    }

    public String[] getTypeNames() throws IOException {
        Set<QName> featureTypeNames = this.wfs.getFeatureTypeNames();
        ArrayList<String> sorted = new ArrayList<String>(featureTypeNames.size());
        for (QName name : featureTypeNames) {
            sorted.add(name.getPrefix() + ":" + name.getLocalPart());
        }
        Collections.sort(sorted);
        return sorted.toArray(new String[sorted.size()]);
    }

    public void dispose() {
        this.wfs.dispose();
    }

    private WFSResponse executeGetFeatures(Query query, Transaction transaction, GetFeature.ResultType resultType) throws IOException {
        String outputFormat = this.wfs.getDefaultOutputFormat(WFSOperationType.GET_FEATURE);
        String srsName = this.adaptQueryForSupportedCrs((DefaultQuery)query);
        GetFeatureQueryAdapter request = new GetFeatureQueryAdapter(query, outputFormat, srsName, resultType);
        WFSResponse response = this.sendGetFeatures(request);
        return response;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        if (Filter.EXCLUDE.equals(query.getFilter())) {
            return new EmptyFeatureReader((FeatureType)this.getQueryType(query));
        }
        query = new DefaultQuery(query);
        Filter[] filters = this.wfs.splitFilters(query.getFilter());
        Filter supportedFilter = filters[0];
        Filter postFilter = filters[1];
        LOGGER.fine("Supported filter:  " + supportedFilter);
        LOGGER.fine("Unupported filter: " + postFilter);
        ((DefaultQuery)query).setFilter(supportedFilter);
        ((DefaultQuery)query).setMaxFeatures(this.getMaxFeatures(query));
        CoordinateReferenceSystem queryCrs = query.getCoordinateSystem();
        WFSResponse response = this.executeGetFeatures(query, transaction, GetFeature.ResultType.RESULTS);
        Object result = WFSExtensions.process(this, response);
        if (result instanceof WFSException) {
            throw (WFSException)result;
        }
        if (!(result instanceof GetFeatureParser)) {
            throw new IllegalStateException("Unknown response result for GetFeature: " + result);
        }
        GetFeatureParser parser = (GetFeatureParser)result;
        SimpleFeatureType contentType = this.getQueryType(query);
        WFSFeatureReader reader = new WFSFeatureReader(parser);
        if (!reader.hasNext()) {
            return new EmptyFeatureReader((FeatureType)contentType);
        }
        SimpleFeatureType readerType = (SimpleFeatureType)reader.getFeatureType();
        CoordinateReferenceSystem readerCrs = readerType.getCoordinateReferenceSystem();
        if (queryCrs != null && !queryCrs.equals(readerCrs)) {
            try {
                reader = new ReprojectFeatureReader((FeatureReader)reader, queryCrs);
            }
            catch (Exception e) {
                throw new DataSourceException((Throwable)e);
            }
        }
        if (Filter.INCLUDE != postFilter) {
            reader = new FilteringFeatureReader((FeatureReader)reader, postFilter);
        }
        if (!contentType.equals(readerType)) {
            boolean cloneContents = false;
            reader = new ReTypeFeatureReader((FeatureReader)reader, contentType, false);
        }
        if (this.maxFeaturesHardLimit > 0 || query.getMaxFeatures() != Integer.MAX_VALUE) {
            int maxFeatures = this.maxFeaturesHardLimit > 0 ? Math.min(this.maxFeaturesHardLimit, query.getMaxFeatures()) : query.getMaxFeatures();
            reader = new MaxFeatureReader((FeatureReader)reader, maxFeatures);
        }
        return reader;
    }

    private WFSResponse sendGetFeatures(GetFeature request) throws IOException {
        WFSResponse response = this.useHttpPostFor(WFSOperationType.GET_FEATURE) ? this.wfs.issueGetFeaturePOST(request) : this.wfs.issueGetFeatureGET(request);
        return response;
    }

    SimpleFeatureType getQueryType(Query query) throws IOException {
        String typeName = query.getTypeName();
        SimpleFeatureType featureType = this.getSchema(typeName);
        CoordinateReferenceSystem coordinateSystemReproject = query.getCoordinateSystemReproject();
        String[] propertyNames = query.getPropertyNames();
        SimpleFeatureType queryType = featureType;
        if (propertyNames != null && propertyNames.length > 0) {
            try {
                queryType = DataUtilities.createSubType((SimpleFeatureType)queryType, (String[])propertyNames);
            }
            catch (SchemaException e) {
                throw new DataSourceException((Throwable)e);
            }
        } else {
            propertyNames = DataUtilities.attributeNames((SimpleFeatureType)featureType);
        }
        if (coordinateSystemReproject != null) {
            try {
                queryType = DataUtilities.createSubType((SimpleFeatureType)queryType, (String[])propertyNames, (CoordinateReferenceSystem)coordinateSystemReproject);
            }
            catch (SchemaException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
        return queryType;
    }

    public WFSFeatureSource getFeatureSource(String typeName) throws IOException {
        return new WFSFeatureSource(this, typeName);
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This is a read only DataStore");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This is a read only DataStore");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("This is a read only DataStore");
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        Set<QName> featureTypeNames = this.wfs.getFeatureTypeNames();
        String namespaceURI = typeName.getNamespaceURI();
        String localPart = typeName.getLocalPart();
        for (QName qname : featureTypeNames) {
            if (!namespaceURI.equals(qname.getNamespaceURI()) || !localPart.equals(qname.getLocalPart())) continue;
            String prefixedName = qname.getPrefix() + ":" + localPart;
            return this.getFeatureSource(prefixedName);
        }
        throw new SchemaNotFoundException(typeName.getURI());
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WFS does not support update schema");
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WFS does not support update schema");
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("WFS DataStore does not support createSchema");
    }

    @Override
    public QName getFeatureTypeName(String typeName) {
        return this.wfs.getFeatureTypeName(typeName);
    }

    @Override
    public String getFeatureTypeTitle(String typeName) {
        return this.wfs.getFeatureTypeTitle(typeName);
    }

    @Override
    public String getFeatureTypeAbstract(String typeName) {
        return this.wfs.getFeatureTypeAbstract(typeName);
    }

    @Override
    public ReferencedEnvelope getFeatureTypeWGS84Bounds(String typeName) {
        return this.wfs.getFeatureTypeWGS84Bounds(typeName);
    }

    @Override
    public ReferencedEnvelope getFeatureTypeBounds(String typeName) {
        ReferencedEnvelope nativeBounds;
        ReferencedEnvelope wgs84Bounds = this.wfs.getFeatureTypeWGS84Bounds(typeName);
        CoordinateReferenceSystem ftypeCrs = this.getFeatureTypeCRS(typeName);
        try {
            nativeBounds = wgs84Bounds.transform(ftypeCrs, true);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Can't transform bounds of " + typeName + " to " + this.wfs.getDefaultCRS(typeName), e);
            nativeBounds = new ReferencedEnvelope(ftypeCrs);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, "Can't transform bounds of " + typeName + " to " + this.wfs.getDefaultCRS(typeName), e);
            nativeBounds = new ReferencedEnvelope(ftypeCrs);
        }
        return nativeBounds;
    }

    @Override
    public CoordinateReferenceSystem getFeatureTypeCRS(String typeName) {
        String defaultCRS = this.wfs.getDefaultCRS(typeName);
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)defaultCRS);
        }
        catch (NoSuchAuthorityCodeException e) {
            LOGGER.info("Authority not found for " + typeName + " CRS: " + defaultCRS);
            if (defaultCRS.toUpperCase().startsWith("URN")) {
                String code = defaultCRS.substring(defaultCRS.lastIndexOf(":") + 1);
                String epsgCode = "EPSG:" + code;
                try {
                    crs = CRS.decode((String)epsgCode);
                }
                catch (Exception e1) {
                    LOGGER.log(Level.WARNING, "can't decode CRS " + epsgCode + " for " + typeName + ". Assigning DefaultEngineeringCRS.GENERIC_2D: " + DefaultEngineeringCRS.GENERIC_2D);
                    crs = DefaultEngineeringCRS.GENERIC_2D;
                }
            }
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, "Error creating CRS " + typeName + ": " + defaultCRS, e);
        }
        return crs;
    }

    @Override
    public Set<String> getFeatureTypeKeywords(String typeName) {
        return this.wfs.getFeatureTypeKeywords(typeName);
    }

    @Override
    public URL getDescribeFeatureTypeURL(String typeName) {
        return this.wfs.getDescribeFeatureTypeURLGet(typeName);
    }

    @Override
    public String getServiceAbstract() {
        return this.wfs.getServiceAbstract();
    }

    @Override
    public Set<String> getServiceKeywords() {
        return this.wfs.getServiceKeywords();
    }

    @Override
    public URI getServiceProviderUri() {
        return this.wfs.getServiceProviderUri();
    }

    @Override
    public URL getCapabilitiesURL() {
        URL capsUrl = this.wfs.getOperationURL(WFSOperationType.GET_CAPABILITIES, false);
        if (capsUrl == null) {
            capsUrl = this.wfs.getOperationURL(WFSOperationType.GET_CAPABILITIES, true);
        }
        return capsUrl;
    }

    @Override
    public String getServiceTitle() {
        return this.wfs.getServiceTitle();
    }

    @Override
    public String getServiceVersion() {
        return this.wfs.getServiceVersion().toString();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        if (!Filter.INCLUDE.equals(query.getFilter())) {
            return null;
        }
        String typeName = query.getTypeName();
        ReferencedEnvelope featureTypeBounds = this.getFeatureTypeBounds(typeName);
        CoordinateReferenceSystem featureTypeCrs = featureTypeBounds.getCoordinateReferenceSystem();
        CoordinateReferenceSystem queryCrs = query.getCoordinateSystem();
        if (queryCrs != null && !CRS.equalsIgnoreMetadata((Object)queryCrs, (Object)featureTypeCrs)) {
            try {
                featureTypeBounds = featureTypeBounds.transform(queryCrs, true);
            }
            catch (TransformException e) {
                LOGGER.log(Level.INFO, "Error transforming bounds for " + typeName, e);
                featureTypeBounds = null;
            }
            catch (FactoryException e) {
                LOGGER.log(Level.INFO, "Error transforming bounds for " + typeName, e);
                featureTypeBounds = null;
            }
        }
        return featureTypeBounds;
    }

    public int getCount(Query query) throws IOException {
        int hits;
        Filter[] filters = this.wfs.splitFilters(query.getFilter());
        Filter postFilter = filters[1];
        if (!Filter.INCLUDE.equals(postFilter)) {
            return -1;
        }
        WFSResponse response = this.executeGetFeatures(query, Transaction.AUTO_COMMIT, GetFeature.ResultType.HITS);
        Object process = WFSExtensions.process(this, response);
        if (!(process instanceof GetFeatureParser)) {
            LOGGER.info("GetFeature with resultType=hits resulted in " + process);
        }
        if ((hits = ((GetFeatureParser)process).getNumberOfFeatures()) != -1 && this.getMaxFeatures() > 0) {
            hits = Math.min(hits, this.getMaxFeatures());
        }
        return hits;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WFSDataStore[");
        sb.append("version=").append(this.getServiceVersion());
        URL capabilitiesUrl = this.getCapabilitiesURL();
        sb.append(", URL=").append(capabilitiesUrl);
        sb.append(", max features=").append(this.maxFeaturesHardLimit == 0 ? "not set" : String.valueOf(this.maxFeaturesHardLimit));
        sb.append(", prefer POST over GET=").append(this.preferPostOverGet);
        sb.append("]");
        return sb.toString();
    }

    private boolean useHttpPostFor(WFSOperationType operation) {
        if (this.preferPostOverGet && this.wfs.supportsOperation(operation, true)) {
            return true;
        }
        if (this.wfs.supportsOperation(operation, false)) {
            return false;
        }
        throw new IllegalArgumentException("Neither POST nor GET method is supported for the " + (Object)((Object)operation) + " operation by the server");
    }

    private String adaptQueryForSupportedCrs(DefaultQuery query) throws IOException {
        String epsgCode;
        String typeName = query.getTypeName();
        CoordinateReferenceSystem queryCrs = query.getCoordinateSystem();
        String defaultCrs = this.wfs.getDefaultCRS(typeName);
        if (queryCrs == null) {
            LOGGER.warning("Query does not provide a CRS, using default: " + query);
            return defaultCrs;
        }
        CoordinateReferenceSystem crsNative = this.getFeatureTypeCRS(typeName);
        if (CRS.equalsIgnoreMetadata((Object)queryCrs, (Object)crsNative)) {
            epsgCode = defaultCrs;
            LOGGER.fine("request and native crs for " + typeName + " are the same: " + epsgCode);
        } else {
            boolean transform = false;
            epsgCode = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)queryCrs);
            if (epsgCode == null) {
                LOGGER.fine("Can't find the identifier for the request CRS, query will be performed in native CRS");
                transform = true;
            } else {
                epsgCode = "EPSG:" + epsgCode;
                LOGGER.fine("Request CRS is " + epsgCode + ", checking if its supported for " + typeName);
                Set<String> supportedCRSIdentifiers = this.wfs.getSupportedCRSIdentifiers(typeName);
                if (supportedCRSIdentifiers.contains(epsgCode)) {
                    LOGGER.fine(epsgCode + " is supported, request will be performed asking " + "for reprojection over it");
                } else {
                    LOGGER.fine(epsgCode + " is not supported for " + typeName + ". Query will be adapted to default CRS " + defaultCrs);
                    transform = true;
                }
                if (transform) {
                    epsgCode = defaultCrs;
                    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
                    SimpleFeatureType ftype = this.getSchema(typeName);
                    ReprojectingFilterVisitor visitor = new ReprojectingFilterVisitor(ff, ftype);
                    Filter filter = query.getFilter();
                    Filter reprojectedFilter = (Filter)filter.accept((FilterVisitor)visitor, null);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Original Filter: " + filter + "\nReprojected filter: " + reprojectedFilter);
                    }
                    LOGGER.fine("Query filter reprojected to native CRS for " + typeName);
                    query.setFilter(reprojectedFilter);
                }
            }
        }
        return epsgCode;
    }

    protected int getMaxFeatures(Query query) {
        int maxFeaturesDataStoreLimit = this.getMaxFeatures();
        int queryMaxFeatures = query.getMaxFeatures();
        int maxFeatures = Integer.MAX_VALUE;
        if (Integer.MAX_VALUE != queryMaxFeatures) {
            maxFeatures = queryMaxFeatures;
        }
        if (maxFeaturesDataStoreLimit > 0) {
            maxFeatures = Math.min(maxFeaturesDataStoreLimit, maxFeatures);
        }
        return maxFeatures;
    }
}

