/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import org.geotools.geometry.GeneralDirectPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSEnvelope
implements Envelope {
    private String epsgCode;
    protected double minX;
    protected double minY;
    protected double maxX;
    protected double maxY;

    public CRSEnvelope() {
    }

    public CRSEnvelope(String epsgCode, double minX, double minY, double maxX, double maxY) {
        this.epsgCode = epsgCode;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public String getEPSGCode() {
        return this.epsgCode;
    }

    public void setEPSGCode(String epsgCode) {
        this.epsgCode = epsgCode;
    }

    public int getDimension() {
        return 2;
    }

    public double getMinimum(int dimension) {
        if (dimension == 0) {
            return this.getMinX();
        }
        return this.getMinY();
    }

    public double getMaximum(int dimension) {
        if (dimension == 0) {
            return this.getMaxX();
        }
        return this.getMaxY();
    }

    public double getCenter(int dimension) {
        return this.getMedian(dimension);
    }

    public double getMedian(int dimension) {
        double min;
        if (dimension == 0) {
            min = this.getMinX();
            double max = this.getMaxX();
        } else {
            min = this.getMinY();
            double max = this.getMaxY();
        }
        return min + this.getLength(dimension) / 2.0;
    }

    public double getLength(int dimension) {
        return this.getSpan(dimension);
    }

    public double getSpan(int dimension) {
        double max;
        double min;
        if (dimension == 0) {
            min = this.getMinX();
            max = this.getMaxX();
        } else {
            min = this.getMinY();
            max = this.getMaxY();
        }
        return max - min;
    }

    public DirectPosition getUpperCorner() {
        return new GeneralDirectPosition(this.getMaxX(), this.getMaxY());
    }

    public DirectPosition getLowerCorner() {
        return new GeneralDirectPosition(this.getMinX(), this.getMinY());
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public String toString() {
        return this.epsgCode.toString() + " [" + this.minX + "," + this.minY + " " + this.maxX + "," + this.maxY + "]";
    }
}

