/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapBoundsEvent;
import org.geotools.map.event.MapBoundsListener;
import org.geotools.map.event.MapLayerEvent;
import org.geotools.referencing.CRS;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMSMapLayer
extends DefaultMapLayer
implements MapLayer,
MapBoundsListener,
ComponentListener {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.map");
    static GridCoverageFactory gcf = new GridCoverageFactory();
    private Layer layer;
    private WebMapServer wms;
    GridCoverage2D grid;
    private ReferencedEnvelope viewport;
    private ReferencedEnvelope bounds;
    private int width = 400;
    private int height = 200;
    private StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
    private boolean transparent = true;
    private String bgColour;
    private String exceptions = "application/vnd.ogc.se_inimage";
    private static ExecutorService executor = Executors.newCachedThreadPool();
    Runnable getmap = new Runnable(){

        public void run() {
            try {
                WMSMapLayer.this.getmap();
            }
            catch (Throwable t) {
                LOGGER.log(Level.FINE, "Unable to refresh getmap", t);
            }
        }
    };

    public WMSMapLayer(WebMapServer wms, Layer layer) {
        super((FeatureSource)null, null, "");
        this.layer = layer;
        this.wms = wms;
        this.setDefaultStyle();
        executor.execute(this.getmap);
    }

    public void setDefaultStyle() {
        RasterSymbolizer symbolizer = this.factory.createRasterSymbolizer();
        Style style = this.factory.createStyle();
        Rule[] rules = new Rule[]{this.factory.createRule()};
        rules[0].setSymbolizers(new Symbolizer[]{symbolizer});
        FeatureTypeStyle type = this.factory.createFeatureTypeStyle(rules);
        style.addFeatureTypeStyle(type);
        this.setStyle(style);
    }

    private static ReferencedEnvelope calculateRequestBBox(Layer layer, ReferencedEnvelope viewport, CoordinateReferenceSystem crs) throws Exception {
        ReferencedEnvelope interestBBox;
        ReferencedEnvelope reprojectedViewportBBox;
        GeneralEnvelope general = layer.getEnvelope(crs);
        ReferencedEnvelope layersBBox = new ReferencedEnvelope((org.opengis.geometry.Envelope)general);
        if (layersBBox.isNull()) {
            layersBBox = null;
        }
        if (viewport == null) {
            viewport = layersBBox;
        }
        if ((reprojectedViewportBBox = viewport.transform(crs, true)).isNull()) {
            // empty if block
        }
        if ((interestBBox = layersBBox == null ? reprojectedViewportBBox : new ReferencedEnvelope(reprojectedViewportBBox.intersection((Envelope)layersBBox), crs)).isNull()) {
            return null;
        }
        return interestBBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getmap() throws Exception {
        GetMapRequest mapRequest = this.wms.createGetMapRequest();
        mapRequest.addLayer(this.layer);
        mapRequest.setDimensions(this.getWidth(), this.getHeight());
        mapRequest.setFormat("image/png");
        if (this.bgColour != null) {
            mapRequest.setBGColour(this.bgColour);
        }
        mapRequest.setExceptions(this.exceptions);
        Set<String> srs = this.layer.getSrs();
        String srsName = "EPSG:4326";
        srsName = srs.contains("EPSG:4326") ? "EPSG:4326" : srs.iterator().next();
        CoordinateReferenceSystem crs = CRS.decode((String)srsName);
        ReferencedEnvelope requestBBox = this.viewport != null ? WMSMapLayer.calculateRequestBBox(this.layer, this.viewport, crs) : this.getBounds();
        mapRequest.setSRS(srsName);
        mapRequest.setBBox((BoundingBox)requestBBox);
        mapRequest.setTransparent(this.transparent);
        URL request = mapRequest.getFinalURL();
        System.out.println(request.toString());
        InputStream is = null;
        try {
            URLConnection connection = request.openConnection();
            String type = connection.getContentType();
            is = connection.getInputStream();
            if (type.equalsIgnoreCase("image/png")) {
                BufferedImage image = ImageIO.read(is);
                System.out.println("get map completed");
                this.grid = gcf.create((CharSequence)this.layer.getTitle(), (RenderedImage)image, (org.opengis.geometry.Envelope)requestBBox);
                this.featureSource = DataUtilities.source((FeatureCollection)FeatureUtilities.wrapGridCoverage((GridCoverage2D)this.grid));
                if (this.viewport == null) {
                    System.out.println("get map complete but viewport not yet established");
                } else {
                    this.fireMapLayerListenerLayerChanged(new MapLayerEvent((Object)this, 3));
                }
            } else {
                System.out.println("error content type is " + type);
                if (StringUtils.contains((String)type, (String)"text") || StringUtils.contains((String)type, (String)"xml")) {
                    String line = "";
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void mapBoundsChanged(MapBoundsEvent event) {
        this.viewport = ((MapContext)event.getSource()).getAreaOfInterest();
        if (!this.viewport.equals((Object)event.getOldAreaOfInterest())) {
            System.out.println("bbox changed - fetching new grid");
            executor.execute(this.getmap);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public GridCoverage2D getGrid() {
        return this.grid;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        Component c = (Component)e.getSource();
        this.width = c.getWidth();
        this.height = c.getHeight();
    }

    public void componentShown(ComponentEvent e) {
        Component c = (Component)e.getSource();
        this.width = c.getWidth();
        this.height = c.getHeight();
    }

    public String getBgColour() {
        return this.bgColour;
    }

    public void setBgColour(String bgColour) {
        this.bgColour = bgColour;
    }

    public String getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String exceptions) {
        this.exceptions = exceptions;
    }

    public synchronized ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            HashMap<Object, CRSEnvelope> bboxes = this.layer.getBoundingBoxes();
            Set<String> srs = this.layer.getSrs();
            String srsName = "EPSG:4326";
            srsName = srs.contains("EPSG:4326") ? "EPSG:4326" : srs.iterator().next();
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)srsName);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Bounds unavailable for layer" + this.layer);
                return null;
            }
            GeneralEnvelope general = this.layer.getEnvelope(crs);
            this.bounds = new ReferencedEnvelope((org.opengis.geometry.Envelope)general);
        }
        return this.bounds;
    }
}

