/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wps.request;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wps10.DataInputsType1;
import net.opengis.wps10.DataType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.Wps10Factory;
import org.geotools.data.wps.request.AbstractWPSRequest;
import org.geotools.data.wps.request.ExecuteProcessRequest;
import org.geotools.wps.WPS;
import org.geotools.wps.WPSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecuteProcessRequest
extends AbstractWPSRequest
implements ExecuteProcessRequest {
    private boolean usePost = true;
    private Properties inputs = new Properties();

    public AbstractExecuteProcessRequest(URL onlineResource, Properties properties) {
        super(onlineResource, properties);
    }

    protected void initRequest() {
        this.setProperty("REQUEST", "Execute");
    }

    @Override
    public void setIdentifier(String identifier) {
        this.setProperty("IDENTIFIER", identifier);
    }

    protected abstract void initVersion();

    public boolean requiresPost() {
        return this.usePost;
    }

    public void performPostOutput(OutputStream outputStream) throws IOException {
        WPSConfiguration config = new WPSConfiguration();
        Encoder encoder = new Encoder((Configuration)config);
        encoder.setIndenting(true);
        ExecuteType request = this.createExecuteType();
        encoder.encode((Object)request, WPS.Execute, outputStream);
    }

    private ExecuteType createExecuteType() {
        ExecuteType request = Wps10Factory.eINSTANCE.createExecuteType();
        CodeType codetype = Ows11Factory.eINSTANCE.createCodeType();
        String iden = (String)this.properties.get("IDENTIFIER");
        codetype.setValue(iden);
        request.setIdentifier(codetype);
        request.setService("WPS");
        request.setVersion("1.0.0");
        if (this.inputs != null && !this.inputs.isEmpty()) {
            DataInputsType1 inputtypes = Wps10Factory.eINSTANCE.createDataInputsType1();
            Set<Object> keyset = this.inputs.keySet();
            for (Object key : keyset) {
                List objects = (List)this.inputs.get(key);
                for (DataType dt : objects) {
                    InputType input = Wps10Factory.eINSTANCE.createInputType();
                    CodeType ct = Ows11Factory.eINSTANCE.createCodeType();
                    ct.setValue((String)key);
                    input.setIdentifier(ct);
                    input.setData(dt);
                    inputtypes.getInput().add((Object)input);
                }
            }
            request.setDataInputs(inputtypes);
        }
        return request;
    }

    @Override
    public void addInput(String name, List<DataType> value) {
        if (value == null) {
            this.inputs.remove(name);
        } else {
            this.inputs.put(name, value);
        }
    }
}

