/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.db2.DB2SQLDialectPrepared;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class DB2NGDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"db2");
    public static final String DriverClassName = "com.ibm.db2.jcc.DB2Driver";

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new DB2SQLDialectPrepared(dataStore);
    }

    public String getDisplayName() {
        return "DB2 NG";
    }

    protected String getDriverClassName() {
        return DriverClassName;
    }

    protected String getDatabaseID() {
        return (String)DB2NGDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "DB2 Database";
    }

    protected String getValidationQuery() {
        return "select current date from sysibm.sysdummy1";
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String host = null;
        Integer port = null;
        try {
            host = (String)HOST.lookUp(params);
            port = (Integer)PORT.lookUp(params);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String db = (String)DATABASE.lookUp(params);
        if (host == null && port == null && db != null) {
            return "jdbc:" + this.getDatabaseID() + ":" + db;
        }
        return super.getJDBCUrl(params);
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(DB2NGDataStoreFactory.DBTYPE.key, DBTYPE);
    }
}

