/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.NameImpl;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.util.logging.Logging;
import org.geotools.xlink.XLINK;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GML2EncodingUtils {
    static Logger LOGGER = Logging.getLogger((String)"org.geotools.gml");
    static final int LON_LAT = 0;
    static final int LAT_LON = 1;
    static final int INAPPLICABLE = 2;

    public static String epsgCode(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        for (Identifier id : crs.getIdentifiers()) {
            if (id.getAuthority() == null || !id.getAuthority().getTitle().equals(Citations.EPSG.getTitle())) continue;
            return id.getCode();
        }
        return null;
    }

    public static String crs(CoordinateReferenceSystem crs) {
        return GML2EncodingUtils.toURI(crs);
    }

    public static String toURI(CoordinateReferenceSystem crs) {
        return GML2EncodingUtils.toURI(crs, false);
    }

    public static String toURI(CoordinateReferenceSystem crs, boolean forceOldStyle) {
        String code = GML2EncodingUtils.epsgCode(crs);
        int axisOrder = GML2EncodingUtils.axisOrder(crs);
        if (code != null) {
            if (forceOldStyle || axisOrder == 0 || axisOrder == 2) {
                return "http://www.opengis.net/gml/srs/epsg.xml#" + code;
            }
            return "urn:x-ogc:def:crs:EPSG:" + code;
        }
        return null;
    }

    static int axisOrder(CoordinateReferenceSystem crs) {
        CoordinateSystem cs = null;
        if (crs instanceof ProjectedCRS) {
            ProjectedCRS pcrs = (ProjectedCRS)crs;
            cs = pcrs.getBaseCRS().getCoordinateSystem();
        } else if (crs instanceof GeographicCRS) {
            cs = crs.getCoordinateSystem();
        } else {
            return 2;
        }
        int dimension = cs.getDimension();
        int longitudeDim = -1;
        int latitudeDim = -1;
        for (int i = 0; i < dimension; ++i) {
            AxisDirection dir = cs.getAxis(i).getDirection().absolute();
            if (dir.equals((Object)AxisDirection.EAST)) {
                longitudeDim = i;
            }
            if (!dir.equals((Object)AxisDirection.NORTH)) continue;
            latitudeDim = i;
        }
        if (longitudeDim >= 0 && latitudeDim >= 0) {
            if (longitudeDim < latitudeDim) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    public static CoordinateReferenceSystem getCRS(Geometry g) {
        if (g.getUserData() == null) {
            return null;
        }
        if (g.getUserData() instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)g.getUserData();
        }
        if (g.getUserData() instanceof Map) {
            Map userData = (Map)g.getUserData();
            return (CoordinateReferenceSystem)userData.get(CoordinateReferenceSystem.class);
        }
        return null;
    }

    public static String getID(Geometry g) {
        return GML2EncodingUtils.getMetadata(g, "gml:id");
    }

    public static String getName(Geometry g) {
        return GML2EncodingUtils.getMetadata(g, "gml:name");
    }

    public static String getDescription(Geometry g) {
        return GML2EncodingUtils.getMetadata(g, "gml:description");
    }

    static String getMetadata(Geometry g, String metadata) {
        if (g.getUserData() instanceof Map) {
            Map userData = (Map)g.getUserData();
            return (String)userData.get(metadata);
        }
        return null;
    }

    public static Element AbstractFeatureType_encode(Object object, Document document, Element value) {
        Feature feature = (Feature)object;
        FeatureType featureType = feature.getType();
        String namespace = featureType.getName().getNamespaceURI();
        String typeName = featureType.getName().getLocalPart();
        Element encoding = document.createElementNS(namespace, typeName);
        encoding.setAttributeNS(null, "fid", feature.getIdentifier().getID());
        return encoding;
    }

    private static BoundingBox getBoundedBy(Feature feature, Configuration configuration) {
        if (configuration.hasProperty(GMLConfiguration.NO_FEATURE_BOUNDS)) {
            return null;
        }
        BoundingBox bounds = feature.getBounds();
        if (bounds.isEmpty() && (feature.getDefaultGeometryProperty() == null || feature.getDefaultGeometryProperty().getValue() == null)) {
            return null;
        }
        return bounds;
    }

    public static List AbstractFeatureType_getProperties(Object object, XSDElementDeclaration element, SchemaIndex schemaIndex, Set<String> toFilter, Configuration configuration) {
        XSDElementDeclaration e;
        String typeName;
        QName qualifiedTypeName;
        XSDTypeDefinition type;
        Feature feature = (Feature)object;
        if (feature.getUserData().get("xlink:id") != null) {
            return Collections.EMPTY_LIST;
        }
        FeatureType featureType = feature.getType();
        String namespace = featureType.getName().getNamespaceURI();
        if (namespace == null) {
            namespace = element.getTargetNamespace();
        }
        if ((type = schemaIndex.getTypeDefinition(qualifiedTypeName = new QName(namespace, typeName = featureType.getName().getLocalPart()))) == null && (e = schemaIndex.getElementDeclaration(qualifiedTypeName)) != null) {
            type = e.getTypeDefinition();
        }
        if (type == null) {
            if (featureType instanceof SimpleFeatureType) {
                LOGGER.warning("Could find type for " + typeName + " in the schema, generating type from feature.");
                type = GML2EncodingUtils.createXmlTypeFromFeatureType((SimpleFeatureType)featureType, schemaIndex, toFilter);
            } else {
                e = (XSDElementDeclaration)feature.getDescriptor().getUserData().get(XSDElementDeclaration.class);
                if (e != null) {
                    type = e.getTypeDefinition();
                } else {
                    throw new RuntimeException("Could not find type for " + qualifiedTypeName + " in schema");
                }
            }
        }
        List particles = Schemas.getChildElementParticles((XSDTypeDefinition)type, (boolean)true);
        ArrayList<Object[]> properties = new ArrayList<Object[]>();
        for (XSDParticle particle : particles) {
            XSDElementDeclaration attribute = (XSDElementDeclaration)particle.getContent();
            if (attribute.isElementDeclarationReference()) {
                attribute = attribute.getResolvedElementDeclaration();
            }
            if (GML.boundedBy.equals(new QName(attribute.getTargetNamespace(), attribute.getName()))) {
                BoundingBox bounds = GML2EncodingUtils.getBoundedBy(feature, configuration);
                if (bounds == null) continue;
                properties.add(new Object[]{particle, bounds});
                continue;
            }
            if (featureType instanceof SimpleFeatureType) {
                if (!GML2EncodingUtils.isValidDescriptor((ComplexType)featureType, (Name)new NameImpl(attribute.getName()))) continue;
                Object attributeValue = ((SimpleFeature)feature).getAttribute(attribute.getName());
                properties.add(new Object[]{particle, attributeValue});
                continue;
            }
            NameImpl propertyName = new NameImpl(attribute.getTargetNamespace(), attribute.getName());
            if (!GML2EncodingUtils.isValidDescriptor((ComplexType)featureType, (Name)propertyName)) continue;
            for (Property property : feature.getProperties((Name)propertyName)) {
                Object value = property instanceof ComplexAttribute ? property : property.getValue();
                properties.add(new Object[]{particle, value});
            }
        }
        return properties;
    }

    public static XSDTypeDefinition createXmlTypeFromFeatureType(SimpleFeatureType featureType, SchemaIndex schemaIndex, Set<String> toFilter) {
        Document dom;
        XSDFactory f = XSDFactory.eINSTANCE;
        try {
            dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        XSDComplexTypeDefinition type = f.createXSDComplexTypeDefinition();
        type.setTargetNamespace(featureType.getName().getNamespaceURI());
        type.setName(featureType.getTypeName() + "Type");
        type.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        type.setBaseTypeDefinition(schemaIndex.getTypeDefinition(GML.AbstractFeatureType));
        XSDModelGroup group = f.createXSDModelGroup();
        group.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        List attributes = featureType.getAttributeDescriptors();
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeDescriptor attribute = (AttributeDescriptor)attributes.get(i);
            if (toFilter.contains(attribute.getLocalName())) continue;
            XSDElementDeclaration element = f.createXSDElementDeclaration();
            element.setName(attribute.getLocalName());
            element.setNillable(attribute.isNillable());
            if (attribute instanceof GeometryDescriptor) {
                Class binding = attribute.getType().getBinding();
                if (Point.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(GML.PointPropertyType));
                } else if (LineString.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(GML.LineStringPropertyType));
                } else if (Polygon.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(GML.PolygonPropertyType));
                } else if (MultiPoint.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(GML.MultiPointPropertyType));
                } else if (MultiLineString.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(GML.MultiLineStringPropertyType));
                } else if (MultiPolygon.class.isAssignableFrom(binding)) {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(GML.MultiPolygonPropertyType));
                } else {
                    element.setTypeDefinition(schemaIndex.getTypeDefinition(GML.GeometryPropertyType));
                }
            } else {
                element.setTypeDefinition(schemaIndex.getTypeDefinition(XS.STRING));
            }
            XSDParticle particle = f.createXSDParticle();
            particle.setMinOccurs(attribute.getMinOccurs());
            particle.setMaxOccurs(attribute.getMaxOccurs());
            particle.setContent((XSDParticleContent)element);
            particle.setElement(dom.createElementNS("http://www.w3.org/2001/XMLSchema", "element"));
            group.getContents().add((Object)particle);
        }
        XSDParticle particle = f.createXSDParticle();
        particle.setContent((XSDParticleContent)group);
        particle.setElement(dom.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence"));
        type.setContent((XSDComplexTypeContent)particle);
        return type;
    }

    public static Object GeometryPropertyType_getProperty(Geometry geometry, QName name) {
        return GML2EncodingUtils.GeometryPropertyType_getProperty(geometry, name, true);
    }

    public static Object GeometryPropertyType_getProperty(Geometry geometry, QName name, boolean includeAbstractGeometry) {
        String id;
        if (GML.Point.equals(name) || GML.LineString.equals(name) || GML.Polygon.equals(name) || GML.MultiPoint.equals(name) || GML.MultiLineString.equals(name) || GML.MultiPolygon.equals(name) || includeAbstractGeometry && GML._Geometry.equals(name)) {
            if (GML2EncodingUtils.isEmpty(geometry)) {
                return null;
            }
            return geometry;
        }
        if (XLINK.HREF.equals(name) && GML2EncodingUtils.isEmpty(geometry) && (id = GML2EncodingUtils.getID(geometry)) != null) {
            return "#" + id;
        }
        return null;
    }

    public static List GeometryPropertyType_getProperties(Geometry geometry) {
        String id = GML2EncodingUtils.getID(geometry);
        if (!GML2EncodingUtils.isEmpty(geometry) && id != null) {
            return Collections.singletonList(new Object[]{Encoder.COMMENT, "#" + id});
        }
        return null;
    }

    static boolean isEmpty(Geometry geometry) {
        if (geometry.isEmpty()) {
            return !(geometry instanceof GeometryCollection) || ((GeometryCollection)geometry).getNumGeometries() == 0;
        }
        return false;
    }

    private static boolean isValidDescriptor(ComplexType type, Name name) {
        if (type.getDescriptor(name) != null) {
            return true;
        }
        if (type.getSuper() instanceof ComplexType) {
            return GML2EncodingUtils.isValidDescriptor((ComplexType)type.getSuper(), name);
        }
        return false;
    }
}

