/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circle {
    private Coordinate center = new Coordinate(0.0, 0.0);
    private double radius = 0.0;
    private PrecisionModel precisionModel = new PrecisionModel();
    private static final double TWO_PI = Math.PI * 2;

    protected Circle() {
    }

    public Circle(Coordinate center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public Circle(double xCenter, double yCenter, double radius) {
        this(new Coordinate(xCenter, yCenter), radius);
    }

    public Circle(double xLeft, double yUpper, double xRight, double yLower) {
        double side = Math.min(Math.abs(xRight - xLeft), Math.abs(yLower - yUpper));
        this.center.x = Math.min(xRight, xLeft) + side / 2.0;
        this.center.y = Math.min(yUpper, yLower) + side / 2.0;
        this.radius = side / 2.0;
    }

    public Circle(Coordinate point1, Coordinate point2, Coordinate point3) {
        this.initThreePointCircle(point1, point2, point3);
    }

    public Circle(double x1, double y1, double x2, double y2, double x3, double y3) {
        this(new Coordinate(x1, y1), new Coordinate(x2, y2), new Coordinate(x3, y3));
    }

    public void shift(double deltaX, double deltaY) {
        this.center.x += deltaX;
        this.center.y += deltaY;
    }

    public void move(double x, double y) {
        this.center.x = x;
        this.center.y = y;
    }

    private void initThreePointCircle(Coordinate p1, Coordinate p2, Coordinate p3) {
        double x = 0.0;
        double y = 0.0;
        double rad = 0.0;
        double a13 = 2.0 * (p1.x - p3.x);
        double b13 = 2.0 * (p1.y - p3.y);
        double c13 = p1.y * p1.y - p3.y * p3.y + (p1.x * p1.x - p3.x * p3.x);
        double a23 = 2.0 * (p2.x - p3.x);
        double b23 = 2.0 * (p2.y - p3.y);
        double c23 = p2.y * p2.y - p3.y * p3.y + (p2.x * p2.x - p3.x * p3.x);
        double smallNumber = 0.01;
        if (Math.abs(a13) < smallNumber && Math.abs(b13) < smallNumber || Math.abs(a13) < smallNumber && Math.abs(b13) < smallNumber) {
            x = 0.0;
            y = 0.0;
            rad = 0.0;
        } else {
            y = (a13 * c23 - a23 * c13) / (a13 * b23 - a23 * b13);
            x = Math.abs(a13) > Math.abs(a23) ? (c13 - b13 * y) / a13 : (c23 - b23 * y) / a23;
            rad = Math.sqrt((x - p1.x) * (x - p1.x) + (y - p1.y) * (y - p1.y));
        }
        this.center.x = x;
        this.center.y = y;
        this.radius = rad;
    }

    public Coordinate getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public static Coordinate[] linearizeArc(double x1, double y1, double x2, double y2, double x3, double y3, double tolerence) {
        Coordinate p1 = new Coordinate(x1, y1);
        Coordinate p2 = new Coordinate(x2, y2);
        Coordinate p3 = new Coordinate(x3, y3);
        return new Circle(p1, p2, p3).linearizeArc(p1, p2, p3, tolerence);
    }

    public static Coordinate[] linearizeArc(double x1, double y1, double x2, double y2, double x3, double y3) {
        Coordinate p1 = new Coordinate(x1, y1);
        Coordinate p2 = new Coordinate(x2, y2);
        Coordinate p3 = new Coordinate(x3, y3);
        Circle c = new Circle(p1, p2, p3);
        double tolerence = 0.01 * c.getRadius();
        return c.linearizeArc(p1, p2, p3, tolerence);
    }

    public static Coordinate[] linearizeCircle(double x1, double y1, double x2, double y2, double x3, double y3) {
        Coordinate p1 = new Coordinate(x1, y1);
        Coordinate p2 = new Coordinate(x2, y2);
        Coordinate p3 = new Coordinate(x3, y3);
        Circle c = new Circle(p1, p2, p3);
        double tolerence = 0.01 * c.getRadius();
        return c.linearizeArc(p1, p2, p1, tolerence);
    }

    public static Coordinate[] linearizeCircle(Coordinate p1, Coordinate p2, Coordinate p3, double tolerance) {
        Circle c = new Circle(p1, p2, p3);
        return c.linearizeArc(p1, p2, p1, tolerance);
    }

    public Coordinate[] linearizeArc(Coordinate p1, Coordinate p2, Coordinate p3, double tolerence) {
        Arc arc = this.createArc(p1, p2, p3);
        List<Coordinate> result = this.linearizeInternal(null, arc, tolerence);
        return result.toArray(new Coordinate[result.size()]);
    }

    private List<Coordinate> linearizeInternal(List<Coordinate> coordinates, Arc arc, double tolerence) {
        double arcHt;
        if (coordinates == null) {
            coordinates = new ArrayList<Coordinate>();
        }
        if (Double.compare(arcHt = arc.getArcHeight(), tolerence) <= 0 || Double.isNaN(arcHt) || Double.isInfinite(arcHt)) {
            Coordinate lastCoord;
            int lastIndex = coordinates.size() - 1;
            Coordinate coordinate = lastCoord = lastIndex >= 0 ? coordinates.get(lastIndex) : null;
            if (lastCoord == null || !arc.getP1().equals2D(lastCoord)) {
                coordinates.add(arc.getP1());
                coordinates.add(arc.getP2());
            } else {
                coordinates.add(arc.getP2());
            }
        } else {
            Arc[] splits = arc.split();
            this.linearizeInternal(coordinates, splits[0], tolerence);
            this.linearizeInternal(coordinates, splits[1], tolerence);
        }
        return coordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Circle circle = (Circle)o;
        if (Double.compare(circle.radius, this.radius) != 0) {
            return false;
        }
        return !(this.center != null ? !this.center.equals2D(circle.center) : circle.center != null);
    }

    public String toString() {
        return "Circle with Radius = " + this.radius + " and a center at the coordinates (" + this.center.x + ", " + this.center.y + ")";
    }

    public double getAngle(Coordinate p) {
        double dx = p.x - this.center.x;
        double dy = p.y - this.center.y;
        double angle = dx == 0.0 ? (dy == 0.0 ? 0.0 : (dy > 0.0 ? 1.5707963267948966 : 4.71238898038469)) : (dy == 0.0 ? (dx > 0.0 ? 0.0 : Math.PI) : (dx < 0.0 ? Math.atan(dy / dx) + Math.PI : (dy < 0.0 ? Math.atan(dy / dx) + Math.PI * 2 : Math.atan(dy / dx))));
        return angle;
    }

    public Coordinate getPoint(double angle) {
        double x = Math.cos(angle) * this.radius;
        x += this.center.x;
        x = this.precisionModel.makePrecise(x);
        double y = Math.sin(angle) * this.radius;
        y += this.center.y;
        y = this.precisionModel.makePrecise(y);
        return new Coordinate(x, y);
    }

    public double distanceFromCenter(Coordinate p) {
        return Math.abs(this.center.distance(p));
    }

    public Arc createArc(Coordinate p1, Coordinate p2, Coordinate p3) {
        return new Arc(p1, p2, p3);
    }

    public static double normalizeAngle(double angle) {
        double maxRadians = Math.PI * 2;
        if (angle >= 0.0 && angle <= maxRadians) {
            return angle;
        }
        if (angle < 0.0) {
            return maxRadians - Math.abs(angle);
        }
        return angle % maxRadians;
    }

    public static double subtractAngles(double a1, double a2) {
        if (a1 < a2) {
            return a2 - a1;
        }
        return Math.PI * 2 - Math.abs(a2 - a1);
    }

    public class Arc {
        private Coordinate p1;
        private Coordinate p2;
        private double arcAngle;
        private double p1Angle;
        private double p2Angle;
        private boolean clockwise;

        private Arc(Coordinate p1, Coordinate midPt, Coordinate p2) {
            this.p1 = p1;
            this.p2 = p2;
            this.p1Angle = Circle.this.getAngle(p1);
            if (p1.equals2D(p2)) {
                this.p2Angle = Math.PI * 2 + this.p1Angle;
                this.arcAngle = Math.PI * 2;
            } else {
                this.p2Angle = Circle.this.getAngle(p2);
                double midPtAngle = Circle.this.getAngle(midPt);
                double ccDegrees = Circle.subtractAngles(this.p1Angle, midPtAngle) + Circle.subtractAngles(midPtAngle, this.p2Angle);
                if (ccDegrees < Math.PI * 2) {
                    this.clockwise = false;
                    this.arcAngle = ccDegrees;
                } else {
                    this.clockwise = true;
                    this.arcAngle = Math.PI * 2 - ccDegrees;
                }
            }
        }

        private Arc(Coordinate p1, Coordinate p2, boolean isClockwise) {
            this.p1 = p1;
            this.p2 = p2;
            this.clockwise = isClockwise;
            this.p1Angle = Circle.this.getAngle(p1);
            this.p2Angle = p1.equals2D(p2) ? Math.PI * 2 + this.p1Angle : Circle.this.getAngle(p2);
            this.determineArcAngle();
        }

        private void determineArcAngle() {
            double diff = this.p1.equals2D(this.p2) ? Math.PI * 2 : (this.clockwise ? this.p1Angle - this.p2Angle : this.p2Angle - this.p1Angle);
            this.arcAngle = Circle.normalizeAngle(diff);
        }

        public double getArcHeight() {
            Coordinate chordCenterPt = this.getChordCenterPoint();
            double dist = Circle.this.distanceFromCenter(chordCenterPt);
            if (this.arcAngle > Math.PI) {
                return Circle.this.radius + dist;
            }
            return Circle.this.radius - dist;
        }

        public Coordinate getChordCenterPoint() {
            double centerX = this.p1.x + (this.p2.x - this.p1.x) / 2.0;
            double centerY = this.p1.y + (this.p2.y - this.p1.y) / 2.0;
            return new Coordinate(centerX, centerY);
        }

        public Arc[] split() {
            int directionFactor = this.isClockwise() ? -1 : 1;
            double angleOffset = (double)directionFactor * (this.arcAngle / 2.0);
            double midAngle = this.p1Angle + angleOffset;
            Coordinate newMidPoint = Circle.this.getPoint(midAngle);
            Arc arc1 = new Arc(this.p1, newMidPoint, this.isClockwise());
            Arc arc2 = new Arc(newMidPoint, this.p2, this.isClockwise());
            return new Arc[]{arc1, arc2};
        }

        public Coordinate getP1() {
            return this.p1;
        }

        public Coordinate getP2() {
            return this.p2;
        }

        public double getArcAngle() {
            return this.arcAngle;
        }

        public double getArcAngleDegrees() {
            return Math.toDegrees(this.arcAngle);
        }

        public double getP1Angle() {
            return this.p1Angle;
        }

        public double getP2Angle() {
            return this.p2Angle;
        }

        public boolean isClockwise() {
            return this.clockwise;
        }

        public String toString() {
            return "P1: " + this.p1 + " P2: " + this.p2 + " clockwise: " + this.clockwise;
        }
    }
}

