/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class MultiCurveTypeBinding
extends AbstractComplexBinding {
    protected GeometryFactory gf;

    public MultiCurveTypeBinding(GeometryFactory gf) {
        this.gf = gf;
    }

    public QName getTarget() {
        return GML.MultiCurveType;
    }

    public Class getType() {
        return MultiLineString.class;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List curves = node.getChildValues(LineString.class);
        if (node.hasChild(MultiLineString[].class)) {
            MultiLineString[] lines;
            MultiLineString[] multiLineStringArray = lines = (MultiLineString[])node.getChildValue(MultiLineString[].class);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MultiLineString mline = multiLineStringArray[n2];
                if (mline.getNumGeometries() != 1) {
                    throw new IllegalArgumentException("Unable to handle curve member with multiple segments");
                }
                curves.add(mline.getGeometryN(0));
                ++n2;
            }
        }
        return this.gf.createMultiLineString(curves.toArray(new LineString[curves.size()]));
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if ("curveMember".equals(name.getLocalPart())) {
            MultiLineString multiCurve = (MultiLineString)object;
            LineString[] members = new LineString[multiCurve.getNumGeometries()];
            int i = 0;
            while (i < members.length) {
                members[i] = (LineString)multiCurve.getGeometryN(i);
                ++i;
            }
            return members;
        }
        return null;
    }
}

