/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.geotools.gml3.GML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class MultiPointTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;

    public MultiPointTypeBinding(GeometryFactory gFactory) {
        this.gFactory = gFactory;
    }

    public QName getTarget() {
        return GML.MultiPointType;
    }

    public Class getType() {
        return MultiPoint.class;
    }

    public int getExecutionMode() {
        return 1;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ArrayList<Point> points = new ArrayList<Point>();
        if (node.hasChild(Point.class)) {
            points.addAll(node.getChildValues(Point.class));
        }
        if (node.hasChild(Point[].class)) {
            Point[] p = (Point[])node.getChildValue(Point[].class);
            int i = 0;
            while (i < p.length) {
                points.add(p[i]);
                ++i;
            }
        }
        return this.gFactory.createMultiPoint(points.toArray(new Point[points.size()]));
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if ("pointMember".equals(name.getLocalPart())) {
            MultiPoint multiPoint = (MultiPoint)object;
            Point[] members = new Point[multiPoint.getNumGeometries()];
            int i = 0;
            while (i < members.length) {
                members[i] = (Point)multiPoint.getGeometryN(i);
                ++i;
            }
            return members;
        }
        return null;
    }
}

